/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.generators.noise_parameters.distance_functions;

import de.articdive.jnoise.generators.noise_parameters.distance_functions.DistanceFunction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DistanceFunctionType implements DistanceFunction
{
    EUCLIDEAN{

        @Override
        public double distance(double x0, double x1) {
            return Math.sqrt(EUCLIDEAN_SQUARED.distance(x0, x1));
        }

        @Override
        public double distance(double x0, double y0, double x1, double y1) {
            return Math.sqrt(EUCLIDEAN_SQUARED.distance(x0, y0, x1, y1));
        }

        @Override
        public double distance(double x0, double y0, double z0, double x1, double y1, double z1) {
            return Math.sqrt(EUCLIDEAN_SQUARED.distance(x0, y0, z0, x1, y1, z1));
        }

        @Override
        public double distance(double x0, double y0, double z0, double w0, double x1, double y1, double z1, double w1) {
            return Math.sqrt(EUCLIDEAN_SQUARED.distance(x0, y0, z0, w0, x1, y1, z1, w1));
        }
    }
    ,
    EUCLIDEAN_SQUARED{

        @Override
        public double distance(double x0, double x1) {
            return (x0 - x1) * (x0 - x1);
        }

        @Override
        public double distance(double x0, double y0, double x1, double y1) {
            return (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1);
        }

        @Override
        public double distance(double x0, double y0, double z0, double x1, double y1, double z1) {
            return (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1) + (z0 - z1) * (z0 - z1);
        }

        @Override
        public double distance(double x0, double y0, double z0, double w0, double x1, double y1, double z1, double w1) {
            return (x0 - x1) * (x0 - x1) + (y0 - y1) * (y0 - y1) + (z0 - z1) * (z0 - z1) + (w0 - w1) * (w0 - w1);
        }
    }
    ,
    MANHATTAN{

        @Override
        public double distance(double x0, double x1) {
            return Math.abs(x0 - x1);
        }

        @Override
        public double distance(double x0, double y0, double x1, double y1) {
            return Math.abs(x0 - x1) + Math.abs(y0 - y1);
        }

        @Override
        public double distance(double x0, double y0, double z0, double x1, double y1, double z1) {
            return Math.abs(x0 - x1) + Math.abs(y0 - y1) + Math.abs(z0 - z1);
        }

        @Override
        public double distance(double x0, double y0, double z0, double w0, double x1, double y1, double z1, double w1) {
            return Math.abs(x0 - x1) + Math.abs(y0 - y1) + Math.abs(z0 - z1) + Math.abs(w0 - w1);
        }
    }
    ,
    CHEBYSHEV{

        @Override
        public double distance(double x0, double x1) {
            return Math.abs(x0 - x1);
        }

        @Override
        public double distance(double x0, double y0, double x1, double y1) {
            return Math.max(Math.abs(x0 - x1), Math.abs(y0 - y1));
        }

        @Override
        public double distance(double x0, double y0, double z0, double x1, double y1, double z1) {
            return Math.max(Math.max(Math.abs(x0 - x1), Math.abs(y0 - y1)), Math.abs(z0 - z1));
        }

        @Override
        public double distance(double x0, double y0, double z0, double w0, double x1, double y1, double z1, double w1) {
            return Math.max(Math.max(Math.abs(x0 - x1), Math.abs(y0 - y1)), Math.max(Math.abs(z0 - z1), Math.abs(w0 - w1)));
        }
    };

}

