/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.modules.combination;

import de.articdive.jnoise.core.api.modules.NoiseModule;
import de.articdive.jnoise.core.api.pipeline.NoiseSource;
import de.articdive.jnoise.core.api.pipeline.NoiseSourceBuilder;
import de.articdive.jnoise.modules.combination.Combiner;
import org.jetbrains.annotations.NotNull;

public final class CombinationModule
implements NoiseModule {
    private final NoiseSource a;
    private final NoiseSource b;
    private final Combiner combiner;

    private CombinationModule(@NotNull NoiseSource a, @NotNull NoiseSource b, @NotNull Combiner combiner) {
        this.a = a;
        this.b = b;
        this.combiner = combiner;
    }

    @Override
    public double evaluateNoise(double x) {
        return this.combiner.combine(this.a.evaluateNoise(x), this.b.evaluateNoise(x));
    }

    @Override
    public double evaluateNoise(double x, double y) {
        return this.combiner.combine(this.a.evaluateNoise(x, y), this.b.evaluateNoise(x, y));
    }

    @Override
    public double evaluateNoise(double x, double y, double z) {
        return this.combiner.combine(this.a.evaluateNoise(x, y, z), this.b.evaluateNoise(x, y, z));
    }

    @Override
    public double evaluateNoise(double x, double y, double z, double w) {
        return this.combiner.combine(this.a.evaluateNoise(x, y, z, w), this.b.evaluateNoise(x, y, z, w));
    }

    @NotNull
    public static CombinationModuleBuilder newBuilder() {
        return new CombinationModuleBuilder();
    }

    public static final class CombinationModuleBuilder
    implements NoiseSourceBuilder {
        private NoiseSource a;
        private NoiseSource b;
        private Combiner combiner = Combiner.ADD;

        private CombinationModuleBuilder() {
        }

        @NotNull
        public CombinationModuleBuilder setA(NoiseSource noiseSource) {
            if (noiseSource == null) {
                throw new IllegalArgumentException("First noise source cannot be null.");
            }
            this.a = noiseSource;
            return this;
        }

        @NotNull
        public CombinationModuleBuilder setA(NoiseSourceBuilder noiseSourceBuilder) {
            if (noiseSourceBuilder == null) {
                throw new IllegalArgumentException("First noise source cannot be null.");
            }
            this.a = noiseSourceBuilder.build();
            return this;
        }

        @NotNull
        public CombinationModuleBuilder setB(NoiseSource noiseSource) {
            if (noiseSource == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            this.b = noiseSource;
            return this;
        }

        @NotNull
        public CombinationModuleBuilder setB(NoiseSourceBuilder noiseSourceBuilder) {
            if (noiseSourceBuilder == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            this.b = noiseSourceBuilder.build();
            return this;
        }

        @NotNull
        public CombinationModuleBuilder setCombiner(Combiner combiner) {
            if (combiner == null) {
                throw new IllegalArgumentException("Combiner cannot be null.");
            }
            this.combiner = combiner;
            return this;
        }

        @Override
        @NotNull
        public CombinationModule build() {
            if (this.a == null) {
                throw new IllegalArgumentException("First noise source cannot be null.");
            }
            if (this.b == null) {
                throw new IllegalArgumentException("Second noise source cannot be null.");
            }
            return new CombinationModule(this.a, this.b, this.combiner);
        }
    }
}

