/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.client.renderer.entity;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.client.renderer.NiftyCartsModelLayers;
import net.jmb19905.niftycarts.client.renderer.entity.DrawnRenderer;
import net.jmb19905.niftycarts.client.renderer.entity.model.SupplyCartModel;
import net.jmb19905.niftycarts.entity.SupplyCartEntity;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1535;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2371;
import net.minecraft.class_2582;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4044;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class SupplyCartRenderer
extends DrawnRenderer<SupplyCartEntity, SupplyCartModel> {
    private static final class_2960 TEXTURE = new class_2960("niftycarts", "textures/entity/supply_cart.png");
    private static final class_970<class_1309, class_572<class_1309>, class_572<class_1309>> DUMMY = new class_970(null, null, null, class_310.method_1551().method_1554());
    private final class_572<class_1309> leggings;
    private final class_572<class_1309> armor;

    public SupplyCartRenderer(class_5617.class_5618 renderManager) {
        super(renderManager, new SupplyCartModel(renderManager.method_32167(NiftyCartsModelLayers.SUPPLY_CART)));
        this.leggings = new class_572(renderManager.method_32167(class_5602.field_27579));
        this.armor = new class_572(renderManager.method_32167(class_5602.field_27580));
        this.field_4673 = 1.0f;
    }

    @Override
    protected void renderContents(SupplyCartEntity entity, float delta, class_4587 stack, class_4597 source, int packedLight) {
        class_1799 s;
        class_2371<class_1799> cargo = entity.getCargo();
        Contents contents = Contents.SUPPLIES;
        Iterator it = cargo.iterator();
        block0: while (it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960()) continue;
            for (Contents c : Contents.values()) {
                if (!c.predicate.test((class_1799)s)) continue;
                contents = c;
                break block0;
            }
        }
        while (contents != Contents.SUPPLIES && it.hasNext()) {
            s = (class_1799)it.next();
            if (s.method_7960() || contents.predicate.test((class_1799)s)) continue;
            contents = Contents.SUPPLIES;
        }
        stack.method_22903();
        ((SupplyCartModel)this.model).getBody().method_22703(stack);
        contents.renderer.render(this, entity, stack, source, packedLight, cargo);
        List<Pair<class_6880<class_2582>, class_1767>> list = entity.getBannerPattern();
        if (!list.isEmpty()) {
            stack.method_22904(0.0, -0.6, 1.5);
            this.renderBanner(stack, source, packedLight, list);
        }
        stack.method_22909();
    }

    private void renderFlowers(SupplyCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        ((SupplyCartModel)this.model).getFlowerBasket().method_22698(stack, source.getBuffer(((SupplyCartModel)this.model).method_23500(this.getTextureLocation(entity))), packedLight, class_4608.field_21444);
        class_776 dispatcher = class_310.method_1551().method_1541();
        class_778 renderer = dispatcher.method_3350();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (!(itemStack.method_7909() instanceof class_1747)) continue;
            int ix = i % 2;
            int iz = i / 2;
            class_2680 defaultState = ((class_1747)itemStack.method_7909()).method_7711().method_9564();
            class_2680 state = defaultState.method_28498((class_2769)class_2741.field_12533) ? (class_2680)defaultState.method_11657((class_2769)class_2741.field_12533, (Comparable)class_2756.field_12609) : defaultState;
            class_1087 model = dispatcher.method_3349(state);
            int rgb = class_310.method_1551().method_1505().method_1697(state, null, null, 0);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            stack.method_22903();
            stack.method_22904(0.0, -0.7, -0.1875);
            stack.method_22905(0.65f, 0.65f, 0.65f);
            stack.method_22904((double)ix, 0.5, (double)iz - 1.0);
            stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            renderer.method_3367(stack.method_23760(), source.getBuffer(class_1921.method_23581()), state, model, r, g, b, packedLight, class_4608.field_21444);
            stack.method_22909();
        }
    }

    private void renderWheel(SupplyCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        stack.method_22903();
        stack.method_22904(1.18, 0.1, -0.15);
        class_630 wheel = ((SupplyCartModel)this.model).getWheel();
        wheel.field_3654 = 0.9f;
        wheel.field_3674 = 0.9424779f;
        wheel.method_22698(stack, source.getBuffer(((SupplyCartModel)this.model).method_23500(this.getTextureLocation(entity))), packedLight, class_4608.field_21444);
        stack.method_22909();
    }

    private void renderPaintings(SupplyCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_4588 buf = source.getBuffer(class_1921.method_23572((class_2960)class_310.method_1551().method_18321().method_18342().method_45852()));
        ObjectList types = (ObjectList)StreamSupport.stream(class_7923.field_41182.spliterator(), false).filter(t -> t.method_6945() == 16 && t.method_6943() == 16).collect(Collectors.toCollection(ObjectArrayList::new));
        Random rng = new Random(entity.method_5667().getMostSignificantBits() ^ entity.method_5667().getLeastSignificantBits());
        ObjectLists.shuffle((ObjectList)types, (Random)rng);
        int count = 0;
        for (class_1799 itemStack : cargo) {
            if (itemStack.method_7960()) continue;
            ++count;
        }
        stack.method_22903();
        stack.method_22904(0.0, -0.15625, 0.0);
        stack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
        int n = 0;
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            class_1535 t2 = (class_1535)types.get(i % types.size());
            stack.method_22903();
            stack.method_22904(0.0, ((double)n++ - (double)(count - 1) * 0.5) / (double)count, -0.0625 * (double)i);
            stack.method_22907(class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI));
            this.renderPainting(t2, stack, buf, packedLight);
            stack.method_22909();
        }
        stack.method_22909();
    }

    private void renderSupplies(SupplyCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_2371<class_1799> cargo) {
        class_918 renderer = class_310.method_1551().method_1480();
        Random rng = new Random();
        for (int i = 0; i < cargo.size(); ++i) {
            class_1799 itemStack = (class_1799)cargo.get(i);
            if (itemStack.method_7960()) continue;
            int ix = i % 2;
            int iz = i / 2;
            if (i < cargo.size() - 2 && ((class_1799)cargo.get(i + 2)).method_31573(class_3489.field_16444) || i >= 2 && ((class_1799)cargo.get(i - 2)).method_31573(class_3489.field_16444)) continue;
            double x = ((double)ix - 0.5) * 11.0 / 16.0;
            double z = ((double)iz * 11.0 - 9.0) / 16.0;
            class_1087 model = renderer.method_4019(itemStack, entity.method_37908(), null, i);
            stack.method_22903();
            if (model.method_4712() && itemStack.method_7909() != class_1802.field_8547) {
                stack.method_22904(x, -0.46, z);
                stack.method_22905(0.65f, 0.65f, 0.65f);
                stack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
                if (itemStack.method_7909() == class_1802.field_8255) {
                    stack.method_22905(1.2f, 1.2f, 1.2f);
                    stack.method_22907(class_7833.field_40716.rotationDegrees(ix == 0 ? -90.0f : 90.0f));
                    stack.method_22904(0.5, 0.8, -0.05);
                    stack.method_22907(class_7833.field_40714.rotationDegrees(-22.5f));
                } else if (iz < 1 && itemStack.method_31573(class_3489.field_16444)) {
                    stack.method_22904(0.0, 0.0, 1.0);
                } else if (!model.method_4713()) {
                    stack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                }
                renderer.method_23179(itemStack, class_811.field_4315, false, stack, source, packedLight, class_4608.field_21444, model);
            } else {
                rng.setSeed(32L * (long)i + (long)Objects.hashCode(class_7923.field_41178.method_10221((Object)itemStack.method_7909())));
                stack.method_22904(x, -0.15 + ((ix + iz) % 2 == 0 ? 0.0 : 1.0E-4), z);
                if (class_1738.class.equals(itemStack.method_7909().getClass()) || class_4057.class.equals(itemStack.method_7909().getClass())) {
                    this.renderArmor(entity, stack, source, packedLight, itemStack, ix);
                } else {
                    stack.method_22905(0.7f, 0.7f, 0.7f);
                    stack.method_22907(class_7833.field_40716.rotation(rng.nextFloat() * (float)Math.PI));
                    stack.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
                    int copies = Math.min(itemStack.method_7947(), (itemStack.method_7947() - 1) / 16 + 2);
                    renderer.method_23179(itemStack, class_811.field_4319, false, stack, source, packedLight, class_4608.field_21444, model);
                    for (int n = 1; n < copies; ++n) {
                        stack.method_22903();
                        stack.method_22907(class_7833.field_40718.rotation(rng.nextFloat() * (float)Math.PI));
                        stack.method_22904((double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)((rng.nextFloat() * 2.0f - 1.0f) * 0.05f), -0.1 * (double)n);
                        renderer.method_23179(itemStack, class_811.field_4319, false, stack, source, packedLight, class_4608.field_21444, model);
                        stack.method_22909();
                    }
                }
            }
            stack.method_22909();
        }
    }

    private void renderArmor(SupplyCartEntity entity, class_4587 stack, class_4597 source, int packedLight, class_1799 itemStack, int ix) {
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof class_1738)) {
            return;
        }
        class_1738 armor = (class_1738)item;
        class_1304 slot = class_1309.method_32326((class_1799)itemStack);
        class_572<class_1309> m = slot == class_1304.field_6172 ? this.leggings : this.armor;
        stack.method_22907(class_7833.field_40716.rotation(ix == 0 ? 1.5707964f : -1.5707964f));
        m.method_2805(false);
        m.field_3399 = class_572.class_573.field_3409;
        m.field_3395 = class_572.class_573.field_3409;
        m.field_3400 = false;
        m.field_3396 = 0.0f;
        m.field_3448 = false;
        switch (slot) {
            case field_6169: {
                stack.method_22904(0.0, 0.1, 0.0);
                m.field_3398.field_3654 = 0.2f;
                m.field_3394.method_17138(m.field_3398);
                m.field_3398.field_3665 = true;
                m.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                stack.method_22904(0.0, -0.4, -0.15);
                m.field_27433.field_3654 = -0.15f;
                m.field_3401.field_3654 = -0.15f;
                m.field_3391.field_3654 = 0.9f;
                m.field_3391.field_3665 = true;
                m.field_3401.field_3665 = true;
                m.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                stack.method_22904(0.0, -0.7, -0.15);
                m.field_3391.field_3654 = 0.0f;
                m.field_3392.field_3654 = 1.2f;
                m.field_3397.field_3654 = 1.2f;
                m.field_3392.field_3675 = -0.3f;
                m.field_3397.field_3675 = 0.3f;
                m.field_3391.field_3665 = true;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                stack.method_22904(0.0, -1.15, -0.1);
                m.field_3392.field_3654 = 0.0f;
                m.field_3397.field_3654 = 0.0f;
                m.field_3392.field_3675 = -0.1f;
                m.field_3397.field_3675 = 0.0f;
                m.field_3392.field_3665 = true;
                m.field_3397.field_3665 = true;
            }
        }
        stack.method_22905(0.75f, 0.75f, 0.75f);
        class_4588 armorBuf = class_918.method_27952((class_4597)source, (class_1921)class_1921.method_25448((class_2960)this.getArmorResource(itemStack, slot, null)), (boolean)false, (boolean)itemStack.method_7958());
        if (armor instanceof class_4057) {
            int rgb = ((class_4057)armor).method_7800(itemStack);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            m.method_2828(stack, armorBuf, packedLight, class_4608.field_21444, r, g, b, 1.0f);
            class_4588 overlayBuf = class_918.method_27952((class_4597)source, (class_1921)class_1921.method_25448((class_2960)this.getArmorResource(itemStack, slot, "overlay")), (boolean)false, (boolean)itemStack.method_7958());
            m.method_2828(stack, overlayBuf, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            m.method_2828(stack, armorBuf, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public class_2960 getArmorResource(class_1799 stack, class_1304 slot, @Nullable String type) {
        class_1738 item = (class_1738)stack.method_7909();
        return DUMMY.method_4174(item, DUMMY.method_4173(slot), type);
    }

    private void renderPainting(class_1535 painting, class_4587 stack, class_4588 buf, int packedLight) {
        class_4044 uploader = class_310.method_1551().method_18321();
        int width = painting.method_6945();
        int height = painting.method_6943();
        class_1058 art = uploader.method_18345(painting);
        class_1058 back = uploader.method_18342();
        Matrix4f model = stack.method_23760().method_23761();
        Matrix3f normal = stack.method_23760().method_23762();
        int blockWidth = width / 16;
        int blockHeight = height / 16;
        float offsetX = (float)(-blockWidth) / 2.0f;
        float offsetY = (float)(-blockHeight) / 2.0f;
        float depth = 0.03125f;
        float bu0 = back.method_4594();
        float bu1 = back.method_4577();
        float bv0 = back.method_4593();
        float bv1 = back.method_4575();
        float bup = back.method_4580(1.0);
        float bvp = back.method_4570(1.0);
        double uvX = 16.0 / (double)blockWidth;
        double uvY = 16.0 / (double)blockHeight;
        for (int x = 0; x < blockWidth; ++x) {
            for (int y = 0; y < blockHeight; ++y) {
                float x1 = offsetX + (float)(x + 1);
                float x0 = offsetX + (float)x;
                float y1 = offsetY + (float)(y + 1);
                float y0 = offsetY + (float)y;
                float u0 = art.method_4580(uvX * (double)(blockWidth - x));
                float u1 = art.method_4580(uvX * (double)(blockWidth - x - 1));
                float v0 = art.method_4570(uvY * (double)(blockHeight - y));
                float v1 = art.method_4570(uvY * (double)(blockHeight - y - 1));
                this.vert(model, normal, buf, x1, y0, u1, v0, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x0, y0, u0, v0, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x0, y1, u0, v1, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x1, y1, u1, v1, -0.03125f, 0, 0, -1, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bv0, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bv1, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv1, 0.03125f, 0, 0, 1, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bv0, -0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu1, bvp, 0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bvp, 0.03125f, 0, 1, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv0, 0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bv0, 0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu1, bvp, -0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bvp, -0.03125f, 0, -1, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bup, bv0, 0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bup, bv1, 0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y0, bu0, bv1, -0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x1, y1, bu0, bv0, -0.03125f, -1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bup, bv0, -0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bup, bv1, -0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y0, bu0, bv1, 0.03125f, 1, 0, 0, packedLight);
                this.vert(model, normal, buf, x0, y1, bu0, bv0, 0.03125f, 1, 0, 0, packedLight);
            }
        }
    }

    private void vert(Matrix4f stack, Matrix3f normal, class_4588 buf, float x, float y, float u, float v, float z, int nx, int ny, int nz, int packedLight) {
        buf.method_22918(stack, x, y, z).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(packedLight).method_23763(normal, (float)nx, (float)ny, (float)nz).method_1344();
    }

    @NotNull
    public class_2960 getTextureLocation(SupplyCartEntity entity) {
        return TEXTURE;
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Contents {
        FLOWERS(s -> s.method_7909() instanceof class_1747 && s.method_31573(class_3489.field_20344), SupplyCartRenderer::renderFlowers),
        PAINTINGS(s -> s.method_7909() == class_1802.field_8892, SupplyCartRenderer::renderPaintings),
        WHEEL(s -> s.method_7909() == NiftyCarts.WHEEL, SupplyCartRenderer::renderWheel),
        SUPPLIES(s -> true, SupplyCartRenderer::renderSupplies);

        private final Predicate<? super class_1799> predicate;
        private final ContentsRenderer renderer;

        private Contents(Predicate<? super class_1799> predicate, ContentsRenderer renderer) {
            this.predicate = predicate;
            this.renderer = renderer;
        }
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    private static interface ContentsRenderer {
        public void render(SupplyCartRenderer var1, SupplyCartEntity var2, class_4587 var3, class_4597 var4, int var5, class_2371<class_1799> var6);
    }
}

