/*
 * Decompiled with CFR 0.152.
 */
package net.jmb19905.niftycarts.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.jmb19905.niftycarts.NiftyCarts;
import net.jmb19905.niftycarts.NiftyCartsConfig;
import net.jmb19905.niftycarts.network.clientbound.UpdateDrawnMessage;
import net.jmb19905.niftycarts.util.CartWheel;
import net.jmb19905.niftycarts.util.NiftyWorld;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2573;
import net.minecraft.class_2582;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4981;
import net.minecraft.class_5134;
import net.minecraft.class_5146;
import net.minecraft.class_5275;
import net.minecraft.class_6880;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDrawnEntity
extends class_1297 {
    private static final class_2940<Integer> TIME_SINCE_HIT = class_2945.method_12791(AbstractDrawnEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> FORWARD_DIRECTION = class_2945.method_12791(AbstractDrawnEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DAMAGE_TAKEN = class_2945.method_12791(AbstractDrawnEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_1799> BANNER = class_2945.method_12791(AbstractDrawnEntity.class, (class_2941)class_2943.field_13322);
    private static final UUID PULL_SLOWLY_MODIFIER_UUID = UUID.fromString("49B0E52E-48F2-4D89-BED7-4F5DF26F1263");
    private static final UUID PULL_MODIFIER_UUID = UUID.fromString("BA594616-5BE3-46C6-8B40-7D0230C64B77");
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    protected List<CartWheel> wheels;
    private int pullingId = -1;
    private UUID pullingUUID = null;
    protected double spacing = 1.7;
    public class_1297 pulling;
    protected AbstractDrawnEntity drawn;

    public AbstractDrawnEntity(class_1299<? extends class_1297> entityTypeIn, class_1937 worldIn) {
        super(entityTypeIn, worldIn);
        this.method_49477(1.2f);
        this.field_23807 = true;
        this.initWheels();
    }

    @NotNull
    public class_238 method_5830() {
        return this.method_5829().method_1009(3.0, 3.0, 3.0);
    }

    public void method_5773() {
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (!this.method_5740()) {
            this.method_18800(0.0, this.method_18798().field_1351 - 0.08, 0.0);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        super.method_5773();
        this.tickLerp();
        if (this.pulling == null) {
            this.method_36457(25.0f);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.attemptReattach();
        }
        for (class_1297 entity : this.method_37908().method_8333((class_1297)this, this.method_5829(), class_1301.method_5911((class_1297)this))) {
            this.method_5697(entity);
        }
    }

    public void pulledTick() {
        if (this.pulling == null) {
            return;
        }
        class_243 targetVec = this.getRelativeTargetVec(1.0f);
        this.handleRotation(targetVec);
        while (this.method_36454() - this.field_5982 < -180.0f) {
            this.field_5982 -= 360.0f;
        }
        while (this.method_36454() - this.field_5982 >= 180.0f) {
            this.field_5982 += 360.0f;
        }
        if (this.pulling.method_24828()) {
            targetVec = new class_243(targetVec.field_1352, 0.0, targetVec.field_1350);
        }
        double targetVecLength = targetVec.method_1033();
        double r = 0.2;
        double relativeSpacing = Math.max(this.spacing + 0.5 * (double)this.pulling.method_17681(), 1.0);
        double diff = targetVecLength - relativeSpacing;
        class_243 move = Math.abs(diff) < 0.2 ? this.method_18798() : this.method_18798().method_1019(targetVec.method_1020(targetVec.method_1029().method_1021(relativeSpacing + 0.2 * Math.signum(diff))));
        this.method_24830(true);
        double startX = this.method_23317();
        double startY = this.method_23318();
        double startZ = this.method_23321();
        this.method_5784(class_1313.field_6308, move);
        if (!this.method_5805()) {
            return;
        }
        this.addStats(this.method_23317() - startX, this.method_23318() - startY, this.method_23321() - startZ);
        if (this.method_37908().field_9236) {
            for (CartWheel wheel : this.wheels) {
                wheel.tick();
            }
        } else {
            targetVec = this.getRelativeTargetVec(1.0f);
            if (targetVec.method_1033() > relativeSpacing + 1.0) {
                this.setPulling(null);
            }
        }
        this.updatePassengers();
        if (this.drawn != null) {
            this.drawn.pulledTick();
        }
    }

    private void addStats(double x, double y, double z) {
        int cm;
        if (!this.method_37908().field_9236 && (cm = Math.round(class_3532.method_15355((float)((float)(x * x + y * y + z * z))) * 100.0f)) > 0) {
            for (class_1297 passenger : this.method_5685()) {
                if (!(passenger instanceof class_1657)) continue;
                class_1657 player = (class_1657)passenger;
                player.method_7339(NiftyCarts.CART_ONE_CM, cm);
            }
        }
    }

    public void initWheels() {
        this.wheels = Arrays.asList(new CartWheel(this, 0.9f), new CartWheel(this, -0.9f));
    }

    public boolean shouldRemovePulling() {
        if (this.field_5976) {
            class_243 start = new class_243(this.method_23317(), this.method_23318() + (double)this.method_17682(), this.method_23321());
            class_243 end = new class_243(this.pulling.method_23317(), this.pulling.method_23318() + (double)(this.pulling.method_17682() / 2.0f), this.pulling.method_23321());
            class_3965 result = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            return result.method_17783() == class_239.class_240.field_1332;
        }
        return false;
    }

    public void updatePassengers() {
        for (class_1297 passenger : this.method_5685()) {
            this.method_24201(passenger);
        }
    }

    public class_1297 getPulling() {
        return this.pulling;
    }

    public void setPulling(class_1297 entityIn) {
        if (!this.method_37908().field_9236) {
            if (this.canBePulledBy(entityIn)) {
                if (entityIn == null) {
                    if (this.pulling instanceof class_1309) {
                        class_1324 attr = ((class_1309)this.pulling).method_5996(class_5134.field_23719);
                        if (attr != null) {
                            attr.method_6200(PULL_SLOWLY_MODIFIER_UUID);
                            attr.method_6200(PULL_MODIFIER_UUID);
                        }
                    } else if (this.pulling instanceof AbstractDrawnEntity) {
                        ((AbstractDrawnEntity)this.pulling).drawn = null;
                    }
                    class_2540 buf = PacketByteBufs.create();
                    UpdateDrawnMessage drawnMessage = new UpdateDrawnMessage(-1, this.method_5628());
                    drawnMessage.encode(buf);
                    for (class_3222 player : PlayerLookup.tracking((class_1297)this)) {
                        ServerPlayNetworking.send((class_3222)player, (class_2960)NiftyCarts.UPDATE_DRAWN_MESSAGE_ID, (class_2540)buf);
                    }
                    this.pullingUUID = null;
                    if (this.field_6012 > 20) {
                        this.playDetachSound();
                    }
                } else {
                    class_1324 attr;
                    if (entityIn instanceof class_1309 && (Double)this.getConfig().pullSpeed.get() != 0.0 && (attr = ((class_1309)entityIn).method_5996(class_5134.field_23719)) != null && attr.method_6199(PULL_MODIFIER_UUID) == null) {
                        attr.method_26835(new class_1322(PULL_MODIFIER_UUID, "Pull modifier", ((Double)this.getConfig().pullSpeed.get()).doubleValue(), class_1322.class_1323.field_6331));
                    }
                    if (entityIn instanceof class_1314) {
                        class_1314 pathfinder = (class_1314)entityIn;
                        pathfinder.method_5942().method_6340();
                    }
                    class_2540 buf = PacketByteBufs.create();
                    UpdateDrawnMessage drawnMessage = new UpdateDrawnMessage(entityIn.method_5628(), this.method_5628());
                    drawnMessage.encode(buf);
                    for (class_3222 player : PlayerLookup.tracking((class_1297)this)) {
                        ServerPlayNetworking.send((class_3222)player, (class_2960)NiftyCarts.UPDATE_DRAWN_MESSAGE_ID, (class_2540)buf);
                    }
                    this.pullingUUID = entityIn.method_5667();
                    if (this.field_6012 > 20) {
                        this.playAttachSound();
                    }
                }
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
                this.pulling = entityIn;
                NiftyWorld.get(this.method_37908()).addPulling(this);
            }
        } else {
            if (entityIn == null) {
                this.pullingId = -1;
                for (CartWheel wheel : this.wheels) {
                    wheel.clearIncrement();
                }
                if (this.pulling instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)this.pulling).drawn = null;
                }
            } else {
                this.pullingId = entityIn.method_5628();
                if (entityIn instanceof AbstractDrawnEntity) {
                    ((AbstractDrawnEntity)entityIn).drawn = this;
                }
            }
            this.pulling = entityIn;
            NiftyWorld.get(this.method_37908()).addPulling(this);
        }
    }

    private void playAttachSound() {
        this.method_5783(NiftyCarts.ATTACH_SOUND, 0.2f, 1.0f);
    }

    private void playDetachSound() {
        this.method_5783(NiftyCarts.DETACH_SOUND, 0.2f, 1.0f);
    }

    private void attemptReattach() {
        class_1297 entity;
        if (this.method_37908().field_9236) {
            class_1297 entity2;
            if (this.pullingId != -1 && (entity2 = this.method_37908().method_8469(this.pullingId)) != null && entity2.method_5805()) {
                this.setPulling(entity2);
            }
        } else if (this.pullingUUID != null && (entity = ((class_3218)this.method_37908()).method_14190(this.pullingUUID)) != null && entity.method_5805()) {
            this.setPulling(entity);
        }
    }

    public boolean shouldStopPulledTick() {
        if (!this.method_5805() || this.getPulling() == null || !this.getPulling().method_5805() || this.getPulling().method_5765()) {
            if (this.pulling != null && this.pulling instanceof class_1657) {
                this.setPulling(null);
            } else {
                this.pulling = null;
            }
            return true;
        }
        if (!this.method_37908().field_9236 && this.shouldRemovePulling()) {
            this.setPulling(null);
            return true;
        }
        return false;
    }

    public class_243 getRelativeTargetVec(float delta) {
        double z;
        double y;
        double x;
        if (delta == 1.0f) {
            x = this.pulling.method_23317() - this.method_23317();
            y = this.pulling.method_23318() - this.method_23318();
            z = this.pulling.method_23321() - this.method_23321();
        } else {
            x = class_3532.method_16436((double)delta, (double)this.pulling.field_6038, (double)this.pulling.method_23317()) - class_3532.method_16436((double)delta, (double)this.field_6038, (double)this.method_23317());
            y = class_3532.method_16436((double)delta, (double)this.pulling.field_5971, (double)this.pulling.method_23318()) - class_3532.method_16436((double)delta, (double)this.field_5971, (double)this.method_23318());
            z = class_3532.method_16436((double)delta, (double)this.pulling.field_5989, (double)this.pulling.method_23321()) - class_3532.method_16436((double)delta, (double)this.field_5989, (double)this.method_23321());
        }
        float yaw = (float)Math.toRadians(this.pulling.method_36454());
        float nx = -class_3532.method_15374((float)yaw);
        float nz = class_3532.method_15362((float)yaw);
        double r = 0.2;
        return new class_243(x + (double)nx * 0.2, y, z + (double)nz * 0.2);
    }

    public void handleRotation(class_243 target) {
        this.method_36456(AbstractDrawnEntity.getYaw(target));
        this.method_36457(AbstractDrawnEntity.getPitch(target));
    }

    public static float getYaw(class_243 vec) {
        return class_3532.method_15393((float)((float)Math.toDegrees(-class_3532.method_15349((double)vec.field_1352, (double)vec.field_1350))));
    }

    public static float getPitch(class_243 vec) {
        return class_3532.method_15393((float)((float)Math.toDegrees(-class_3532.method_15349((double)vec.field_1351, (double)class_3532.method_15355((float)((float)(vec.field_1352 * vec.field_1352 + vec.field_1350 * vec.field_1350)))))));
    }

    public double getWheelRotation(int wheel) {
        return this.wheels.get(wheel).getRotation();
    }

    public double getWheelRotationIncrement(int wheel) {
        return this.wheels.get(wheel).getRotationIncrement();
    }

    public abstract class_1792 getCartItem();

    protected boolean canBePulledBy(class_1297 entityIn) {
        if (this.method_37908().field_9236) {
            return true;
        }
        if (entityIn == null) {
            return true;
        }
        return (this.pulling == null || !this.pulling.method_5805()) && !this.method_5626(entityIn) && this.canPull(entityIn);
    }

    private boolean canPull(class_1297 entity) {
        if (entity instanceof class_5146 && !((class_5146)entity).method_6765()) {
            return false;
        }
        if (entity instanceof class_1321 && !((class_1321)entity).method_6181()) {
            return false;
        }
        ArrayList allowed = (ArrayList)this.getConfig().pullAnimals.get();
        if (allowed.isEmpty()) {
            return entity instanceof class_1657 || entity instanceof class_5146 && !(entity instanceof class_4981);
        }
        return allowed.contains(class_1299.method_5890((class_1299)entity.method_5864()).toString());
    }

    protected abstract NiftyCartsConfig.CartConfig getConfig();

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        if (!this.method_37908().field_9236 && this.method_5805()) {
            boolean flag;
            if (source.method_49708(class_8111.field_42344)) {
                return false;
            }
            if (source.method_5529() != null && this.method_5626(source.method_5529())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(10);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
            if (flag || this.getDamageTaken() > 40.0f) {
                this.onDestroyed(source, flag);
                this.setPulling(null);
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    protected class_1269 useBanner(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(class_3489.field_15556)) {
            class_1799 oldBanner = this.getBanner();
            if (!this.method_37908().field_9236) {
                class_1799 banner = stack.method_7971(1);
                if (!oldBanner.method_7960()) {
                    if (stack.method_7960()) {
                        player.method_6122(hand, oldBanner);
                    } else if (!player.method_31548().method_7394(oldBanner)) {
                        player.method_7328(oldBanner, false);
                    }
                }
                this.method_5783(class_3417.field_14718, 1.0f, 0.8f);
                this.setBanner(banner);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    public void onDestroyed(class_1282 source, boolean byCreativePlayer) {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            if (!byCreativePlayer) {
                this.method_5706((class_1935)this.getCartItem());
                this.method_5775(this.getBanner());
            }
            this.onDestroyedAndDoDrops(source);
        }
    }

    public void onDestroyedAndDoDrops(class_1282 source) {
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double dx = (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double dy = (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double dz = (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            this.method_36456((float)((double)this.method_36454() + class_3532.method_15338((double)(this.lerpYaw - (double)this.method_36454())) / (double)this.lerpSteps));
            this.method_36457((float)((double)this.method_36455() + (this.lerpPitch - (double)this.method_36455()) / (double)this.lerpSteps));
            --this.lerpSteps;
            this.method_24830(true);
            this.method_5784(class_1313.field_6308, new class_243(dx, dy, dz));
            this.method_5710(this.method_36454(), this.method_36455());
        }
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_30948() {
        return this.method_5805();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        if (this.method_5787() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.method_5808(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }

    @Nullable
    public class_1309 method_5642() {
        List passengers = this.method_5685();
        if (passengers.isEmpty()) {
            return null;
        }
        class_1297 first = (class_1297)passengers.get(0);
        if (first instanceof class_1429 || !(first instanceof class_1309)) {
            return null;
        }
        return (class_1309)first;
    }

    public boolean method_5787() {
        return false;
    }

    @NotNull
    public class_243 method_24829(class_1309 rider) {
        float[] fArray;
        if (rider.method_6068() == class_1306.field_6183) {
            float[] fArray2 = new float[2];
            fArray2[0] = 90.0f;
            fArray = fArray2;
            fArray2[1] = -90.0f;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = -90.0f;
            fArray = fArray3;
            fArray3[1] = 90.0f;
        }
        for (float angle : fArray) {
            class_243 pos = this.dismount(AbstractDrawnEntity.method_24826((double)this.method_17681(), (double)rider.method_17681(), (float)(this.method_36454() + angle)), rider);
            if (pos == null) continue;
            return pos;
        }
        return this.method_19538();
    }

    private class_243 dismount(class_243 dir, class_1309 rider) {
        double x = this.method_23317() + dir.field_1352;
        double y = this.method_5829().field_1322;
        double z = this.method_23321() + dir.field_1350;
        double limit = this.method_5829().field_1325 + 0.75;
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        block0: for (class_4050 pose : rider.method_24831()) {
            blockPos.method_10102(x, y, z);
            while ((double)blockPos.method_10264() < limit) {
                double ground = this.method_37908().method_30347((class_2338)blockPos);
                if ((double)blockPos.method_10264() + ground > limit) continue block0;
                if (class_5275.method_27932((double)ground)) {
                    class_243 pos = new class_243(x, (double)blockPos.method_10264() + ground, z);
                    if (class_5275.method_27933((class_1941)this.method_37908(), (class_1309)rider, (class_238)rider.method_24833(pose).method_997(pos))) {
                        rider.method_18380(pose);
                        return pos;
                    }
                }
                blockPos.method_10098(class_2350.field_11036);
            }
        }
        return null;
    }

    public void setDamageTaken(float damageTaken) {
        this.field_6011.method_12778(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_6011.method_12789(DAMAGE_TAKEN)).floatValue();
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_6011.method_12778(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_6011.method_12789(TIME_SINCE_HIT);
    }

    public void setForwardDirection(int forwardDirection) {
        this.field_6011.method_12778(FORWARD_DIRECTION, (Object)forwardDirection);
    }

    public int getForwardDirection() {
        return (Integer)this.field_6011.method_12789(FORWARD_DIRECTION);
    }

    public void setBanner(class_1799 banner) {
        this.field_6011.method_12778(BANNER, (Object)banner);
    }

    public class_1799 getBanner() {
        return (class_1799)this.field_6011.method_12789(BANNER);
    }

    public List<Pair<class_6880<class_2582>, class_1767>> getBannerPattern() {
        class_1799 banner = this.getBanner();
        class_1792 class_17922 = banner.method_7909();
        if (class_17922 instanceof class_1746) {
            class_1746 item = (class_1746)class_17922;
            return class_2573.method_24280((class_1767)item.method_7706(), (class_2499)class_2573.method_24281((class_1799)banner));
        }
        return List.of();
    }

    public class_1799 method_31480() {
        return new class_1799((class_1935)this.getCartItem());
    }

    public boolean method_5863() {
        return true;
    }

    protected void method_5693() {
        this.field_6011.method_12784(TIME_SINCE_HIT, (Object)0);
        this.field_6011.method_12784(FORWARD_DIRECTION, (Object)1);
        this.field_6011.method_12784(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(BANNER, (Object)class_1799.field_8037);
    }

    protected void method_5749(class_2487 compound) {
        if (compound.method_25928("PullingUUID")) {
            this.pullingUUID = compound.method_25926("PullingUUID");
        }
        if (compound.method_10545("BannerItem")) {
            this.setBanner(class_1799.method_7915((class_2487)compound.method_10562("BannerItem")));
        }
    }

    protected void method_5652(class_2487 compound) {
        class_1799 banner;
        if (this.pulling != null) {
            compound.method_25927("PullingUUID", this.pullingUUID);
        }
        if (!(banner = this.getBanner()).method_7960()) {
            compound.method_10566("BannerItem", (class_2520)banner.method_7953(new class_2487()));
        }
    }

    public RenderInfo getInfo(float delta) {
        return new RenderInfo(delta);
    }

    public void toggleSlow() {
        class_1297 pulling = this.pulling;
        if (!(pulling instanceof class_1309)) {
            return;
        }
        class_1324 speed = ((class_1309)pulling).method_5996(class_5134.field_23719);
        if (speed == null) {
            return;
        }
        class_1322 modifier = speed.method_6199(PULL_SLOWLY_MODIFIER_UUID);
        if (modifier == null) {
            speed.method_26835(new class_1322(PULL_SLOWLY_MODIFIER_UUID, "Pull slowly modifier", ((Double)this.getConfig().slowSpeed.get()).doubleValue(), class_1322.class_1323.field_6331));
        } else {
            speed.method_6202(modifier);
        }
    }

    public class RenderInfo {
        final float delta;
        class_243 target;
        float yaw = Float.NaN;
        float pitch = Float.NaN;

        public RenderInfo(float delta) {
            this.delta = delta;
        }

        public class_243 getTarget() {
            if (this.target == null) {
                this.target = AbstractDrawnEntity.this.pulling == null ? AbstractDrawnEntity.this.method_5828(this.delta) : AbstractDrawnEntity.this.getRelativeTargetVec(this.delta);
            }
            return this.target;
        }

        public float getYaw() {
            if (Float.isNaN(this.yaw)) {
                this.yaw = AbstractDrawnEntity.this.pulling == null ? class_3532.method_16439((float)this.delta, (float)AbstractDrawnEntity.this.field_5982, (float)AbstractDrawnEntity.this.method_36454()) : AbstractDrawnEntity.getYaw(this.getTarget());
            }
            return this.yaw;
        }

        public float getPitch() {
            if (Float.isNaN(this.pitch)) {
                this.pitch = AbstractDrawnEntity.this.pulling == null ? class_3532.method_16439((float)this.delta, (float)AbstractDrawnEntity.this.field_6004, (float)AbstractDrawnEntity.this.method_36455()) : AbstractDrawnEntity.getPitch(this.target);
            }
            return this.pitch;
        }
    }
}

