/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.rei.category;

import com.simibubi.create.AllFluids;
import com.simibubi.create.compat.rei.display.CreateDisplay;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.FluidTextUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_638;

public abstract class CreateRecipeCategory<T extends class_1860<?>>
implements DisplayCategory<CreateDisplay<T>> {
    protected final CategoryIdentifier<CreateDisplay<T>> type;
    protected final class_2561 title;
    protected final Renderer background;
    protected final Renderer icon;
    private final Supplier<List<T>> recipes;
    private final List<Supplier<? extends class_1799>> catalysts;
    private final int width;
    private final int height;
    private final Function<T, ? extends CreateDisplay<T>> displayFactory;

    public CreateRecipeCategory(Info<T> info) {
        this.type = info.recipeType();
        this.title = info.title();
        this.background = info.background();
        this.icon = info.icon();
        this.recipes = info.recipes();
        this.catalysts = info.catalysts();
        this.width = info.width();
        this.height = info.height();
        this.displayFactory = info.displayFactory();
    }

    public CategoryIdentifier<CreateDisplay<T>> getCategoryIdentifier() {
        return this.type;
    }

    public void registerRecipes(DisplayRegistry registry) {
        for (class_1860 recipe : this.recipes.get()) {
            registry.add((Display)this.displayFactory.apply(recipe), (Object)recipe);
        }
    }

    public void registerCatalysts(CategoryRegistry registry) {
        this.catalysts.forEach(s -> registry.addWorkstations(this.type, new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)((class_1799)s.get()))}));
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public int getDisplayWidth(CreateDisplay<T> display) {
        return this.width;
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public static AllGuiTextures getRenderedSlot(class_1860<?> recipe, int index) {
        AllGuiTextures jeiSlot = AllGuiTextures.JEI_SLOT;
        if (!(recipe instanceof ProcessingRecipe)) {
            return jeiSlot;
        }
        ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
        List<ProcessingOutput> rollableResults = processingRecipe.getRollableResults();
        if (rollableResults.size() <= index) {
            return jeiSlot;
        }
        if (processingRecipe.getRollableResults().get(index).getChance() == 1.0f) {
            return jeiSlot;
        }
        return AllGuiTextures.JEI_CHANCE_SLOT;
    }

    public static void addStochasticTooltip(List<Widget> itemStacks, List<ProcessingOutput> results) {
        CreateRecipeCategory.addStochasticTooltip(itemStacks, results, 1);
    }

    public static void addStochasticTooltip(List<Widget> itemStacks, List<ProcessingOutput> results, int startIndex) {
        itemStacks.stream().filter(widget -> widget instanceof Slot).forEach(widget -> {
            Slot slot = (Slot)widget;
            ClientEntryStacks.setTooltipProcessor((EntryStack)slot.getCurrentEntry(), (entryStack, tooltip) -> {
                ProcessingOutput output = (ProcessingOutput)results.get(0);
                float chance = output.getChance();
                if (chance != 1.0f) {
                    tooltip.add((class_2561)Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065));
                }
                return tooltip;
            });
        });
    }

    public static void addStochasticTooltip(ProcessingOutput output, Tooltip tooltip) {
        float chance = output.getChance();
        if (chance != 1.0f) {
            tooltip.add((class_2561)Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065));
        }
    }

    public static Slot basicSlot(int x, int y) {
        return Widgets.createSlot((Point)CreateRecipeCategory.point(x, y)).disableBackground();
    }

    public static Slot basicSlot(int x, int y, Point origin) {
        return Widgets.createSlot((Point)CreateRecipeCategory.point(origin.getX() + x, origin.getY() + y)).disableBackground();
    }

    public static class_1799 getResultItem(class_1860<?> recipe) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return class_1799.field_8037;
        }
        return recipe.method_8110(level.method_30349());
    }

    public static List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(CreateRecipeCategory::withImprovedVisibility).collect(Collectors.toList());
    }

    public static FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        long displayedAmount = (long)((float)stack.getAmount() * 0.75f) + 250L;
        display.setAmount(displayedAmount);
        return display;
    }

    public static dev.architectury.fluid.FluidStack convertToREIFluid(FluidStack stack) {
        return dev.architectury.fluid.FluidStack.create((class_3611)stack.getFluid(), (long)stack.getAmount(), (class_2487)stack.getTag());
    }

    public static List<dev.architectury.fluid.FluidStack> convertToREIFluids(List<FluidStack> stacks) {
        ArrayList<dev.architectury.fluid.FluidStack> newFluids = new ArrayList<dev.architectury.fluid.FluidStack>();
        stacks.forEach(fluidStack -> newFluids.add(CreateRecipeCategory.convertToREIFluid(fluidStack)));
        return newFluids;
    }

    public static void setFluidRenderRatio(Slot slot) {
        slot.getEntries().forEach(entryStack -> {
            dev.architectury.fluid.FluidStack stack = (dev.architectury.fluid.FluidStack)entryStack.castValue();
            ClientEntryStacks.setFluidRenderRatio((EntryStack)entryStack.cast(), (float)((float)stack.getAmount() / 81000.0f));
        });
    }

    public static void addFluidTooltip(List<Widget> fluidStacks, List<FluidIngredient> inputs, List<FluidStack> outputs) {
        CreateRecipeCategory.addFluidTooltip(fluidStacks, inputs, outputs, -1);
    }

    public static void addFluidTooltip(List<Widget> fluidStacks, List<FluidIngredient> inputs, List<FluidStack> outputs, int index) {
        ArrayList amounts = new ArrayList();
        inputs.forEach(f -> amounts.add(f.getRequiredAmount()));
        outputs.forEach(f -> amounts.add(f.getAmount()));
        fluidStacks.stream().filter(widget -> {
            Slot slot;
            return widget instanceof Slot && (slot = (Slot)widget).getCurrentEntry().getType() == VanillaEntryTypes.FLUID;
        }).forEach(widget -> {
            Slot slot = (Slot)widget;
            ClientEntryStacks.setTooltipProcessor((EntryStack)slot.getCurrentEntry(), (entryStack, tooltip) -> {
                dev.architectury.fluid.FluidStack fluidStack = (dev.architectury.fluid.FluidStack)entryStack.castValue();
                FluidStack fluid = new FluidStack(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
                if (fluid.getFluid().method_15780((class_3611)AllFluids.POTION.get())) {
                    class_2561 name = fluid.getDisplayName();
                    if (tooltip.entries().isEmpty()) {
                        tooltip.entries().add(0, Tooltip.entry((class_2561)name));
                    } else {
                        tooltip.entries().set(0, Tooltip.entry((class_2561)name));
                    }
                    ArrayList<class_2561> potionTooltip = new ArrayList<class_2561>();
                    PotionFluidHandler.addPotionTooltip(fluid, potionTooltip, 1.0f);
                    ArrayList potionEntries = new ArrayList();
                    potionTooltip.forEach(component -> potionEntries.add(Tooltip.entry((class_2561)component)));
                    tooltip.entries().addAll(2, potionEntries.stream().toList());
                }
                FluidUnit unit = (FluidUnit)AllConfigs.client().fluidUnitType.get();
                String amount = FluidTextUtil.getUnicodeMillibuckets((long)((Long)amounts.get(0)), (FluidUnit)unit, (boolean)((Boolean)AllConfigs.client().simplifyFluidUnit.get()));
                class_5250 text = class_2561.method_43470((String)String.valueOf(amount)).method_10852((class_2561)Lang.translateDirect(unit.getTranslationKey(), new Object[0])).method_27692(class_124.field_1065);
                if (tooltip.entries().isEmpty()) {
                    tooltip.entries().add(0, Tooltip.entry((class_2561)text));
                } else {
                    List siblings = ((Tooltip.Entry)tooltip.entries().get(0)).getAsText().method_10855();
                    siblings.add(class_2561.method_43470((String)" "));
                    siblings.add(text);
                }
                tooltip.entries().remove(1);
                return tooltip;
            });
        });
    }

    public static void setFluidTooltip(Slot slot) {
        ClientEntryStacks.setTooltipProcessor((EntryStack)slot.getCurrentEntry(), (entryStack, tooltip) -> {
            dev.architectury.fluid.FluidStack fluidStack = (dev.architectury.fluid.FluidStack)entryStack.castValue();
            FluidStack fluid = new FluidStack(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
            if (fluid.getFluid().method_15780((class_3611)AllFluids.POTION.get())) {
                class_2561 name = fluid.getDisplayName();
                if (tooltip.entries().isEmpty()) {
                    tooltip.entries().add(0, Tooltip.entry((class_2561)name));
                } else {
                    tooltip.entries().set(0, Tooltip.entry((class_2561)name));
                }
                ArrayList<class_2561> potionTooltip = new ArrayList<class_2561>();
                PotionFluidHandler.addPotionTooltip(fluid, potionTooltip, 1.0f);
                ArrayList potionEntries = new ArrayList();
                potionTooltip.forEach(component -> potionEntries.add(Tooltip.entry((class_2561)component)));
                tooltip.entries().addAll(1, potionEntries.stream().toList());
            }
            FluidUnit unit = (FluidUnit)AllConfigs.client().fluidUnitType.get();
            String amount = FluidTextUtil.getUnicodeMillibuckets((long)fluid.getAmount(), (FluidUnit)unit, (boolean)((Boolean)AllConfigs.client().simplifyFluidUnit.get()));
            class_5250 text = class_2561.method_43470((String)String.valueOf(amount)).method_10852((class_2561)Lang.translateDirect(unit.getTranslationKey(), new Object[0])).method_27692(class_124.field_1065);
            if (tooltip.entries().isEmpty()) {
                tooltip.entries().add(0, Tooltip.entry((class_2561)text));
            } else {
                List siblings = ((Tooltip.Entry)tooltip.entries().get(0)).getAsText().method_10855();
                siblings.add(class_2561.method_43470((String)" "));
                siblings.add(text);
            }
            return tooltip;
        });
    }

    public static Point point(int x, int y) {
        return new Point(x, y);
    }

    public void addWidgets(CreateDisplay<T> display, List<Widget> ingredients, Point origin) {
    }

    public void addWidgets(CreateDisplay<T> display, List<Widget> ingredients, Point origin, Rectangle bounds) {
    }

    public List<Widget> setupDisplay(CreateDisplay<T> display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createDrawableWidget((graphics, mouseX, mouseY, partialTick) -> {
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416((float)bounds.getX(), (float)(bounds.getY() + 4), 0.0f);
            this.draw(display.getRecipe(), graphics, mouseX, mouseY);
            this.draw(display.getRecipe(), display, graphics, mouseX, mouseY);
            poseStack.method_22909();
        }));
        this.addWidgets(display, widgets, new Point(bounds.getX(), bounds.getY() + 4));
        this.addWidgets(display, widgets, new Point(bounds.getX(), bounds.getY() + 4), bounds);
        return widgets;
    }

    public void draw(T recipe, class_332 graphics, double mouseX, double mouseY) {
    }

    public void draw(T recipe, CreateDisplay<T> display, class_332 graphics, double mouseX, double mouseY) {
    }

    public record Info<T extends class_1860<?>>(CategoryIdentifier<CreateDisplay<T>> recipeType, class_2561 title, Renderer background, Renderer icon, Supplier<List<T>> recipes, List<Supplier<? extends class_1799>> catalysts, int width, int height, Function<T, ? extends CreateDisplay<T>> displayFactory) {
    }

    public static interface Factory<T extends class_1860<?>> {
        public CreateRecipeCategory<T> create(Info<T> var1);
    }
}

