/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.pulley;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.BlockMovementChecks;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.piston.LinearActuatorBlockEntity;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;

public class PulleyBlockEntity
extends LinearActuatorBlockEntity
implements ThresholdSwitchObservable {
    protected int initialOffset;
    private float prevAnimatedOffset;
    protected class_2338 mirrorParent;
    protected List<class_2338> mirrorChildren;
    public WeakReference<AbstractContraptionEntity> sharedMirrorContraption;

    public PulleyBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        AbstractContraptionEntity ace;
        double expandY = -this.offset;
        if (this.sharedMirrorContraption != null && (ace = (AbstractContraptionEntity)((Object)this.sharedMirrorContraption.get())) != null) {
            expandY = ace.method_23318() - (double)this.field_11867.method_10264();
        }
        return super.createRenderBoundingBox().method_1012(0.0, expandY, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.PULLEY_MAXED);
    }

    @Override
    public void tick() {
        float prevOffset = this.offset;
        super.tick();
        if (this.field_11863.method_8608() && this.mirrorParent != null && (this.sharedMirrorContraption == null || this.sharedMirrorContraption.get() == null || !((AbstractContraptionEntity)((Object)this.sharedMirrorContraption.get())).method_5805())) {
            this.sharedMirrorContraption = null;
            class_2586 class_25862 = this.field_11863.method_8321(this.mirrorParent);
            if (class_25862 instanceof PulleyBlockEntity) {
                PulleyBlockEntity pte = (PulleyBlockEntity)class_25862;
                if (pte.movedContraption != null) {
                    this.sharedMirrorContraption = new WeakReference<AbstractContraptionEntity>(pte.movedContraption);
                }
            }
        }
        if (this.isVirtual()) {
            this.prevAnimatedOffset = this.offset;
        }
        this.invalidateRenderBoundingBox();
        if (prevOffset < 200.0f && this.offset >= 200.0f) {
            this.award(AllAdvancements.PULLEY_MAXED);
        }
    }

    @Override
    protected boolean isPassive() {
        return this.mirrorParent != null;
    }

    @Nullable
    public AbstractContraptionEntity getAttachedContraption() {
        return this.mirrorParent != null && this.sharedMirrorContraption != null ? (AbstractContraptionEntity)((Object)this.sharedMirrorContraption.get()) : this.movedContraption;
    }

    @Override
    protected void assemble() throws AssemblyException {
        class_2338 ropePos;
        class_2680 ropeState;
        int i;
        if (!(this.field_11863.method_8320(this.field_11867).method_26204() instanceof PulleyBlock)) {
            return;
        }
        if (this.speed == 0.0f && this.mirrorParent == null) {
            return;
        }
        int maxLength = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        for (i = 1; i <= maxLength && (AllBlocks.ROPE.has(ropeState = this.field_11863.method_8320(ropePos = this.field_11867.method_10087(i))) || AllBlocks.PULLEY_MAGNET.has(ropeState)); ++i) {
        }
        this.offset = i - 1;
        if (this.offset >= (float)this.getExtensionRange() && this.getSpeed() > 0.0f) {
            return;
        }
        if (this.offset <= 0.0f && this.getSpeed() < 0.0f) {
            return;
        }
        if (!this.field_11863.field_9236 && this.mirrorParent == null) {
            this.needsContraption = false;
            class_2338 anchor = this.field_11867.method_10087(class_3532.method_15375((float)(this.offset + 1.0f)));
            this.initialOffset = class_3532.method_15375((float)this.offset);
            PulleyContraption contraption = new PulleyContraption(this.initialOffset);
            boolean canAssembleStructure = contraption.assemble(this.field_11863, anchor);
            if (canAssembleStructure) {
                class_2350 movementDirection;
                class_2350 class_23502 = movementDirection = this.getSpeed() > 0.0f ? class_2350.field_11033 : class_2350.field_11036;
                if (ContraptionCollider.isCollidingWithWorld(this.field_11863, contraption, anchor.method_10093(movementDirection), movementDirection)) {
                    canAssembleStructure = false;
                }
            }
            if (!canAssembleStructure && this.getSpeed() > 0.0f) {
                return;
            }
            this.removeRopes();
            if (!contraption.getBlocks().isEmpty()) {
                contraption.removeBlocksFromWorld(this.field_11863, class_2338.field_10980);
                this.movedContraption = ControlledContraptionEntity.create(this.field_11863, this, contraption);
                this.movedContraption.method_5814(anchor.method_10263(), anchor.method_10264(), anchor.method_10260());
                this.field_11863.method_8649((class_1297)this.movedContraption);
                this.forceMove = true;
                this.needsContraption = true;
                if (contraption.containsBlockBreakers()) {
                    this.award(AllAdvancements.CONTRAPTION_ACTORS);
                }
                for (class_2338 pos : contraption.createColliders(this.field_11863, class_2350.field_11036)) {
                    class_2586 class_25862;
                    if (pos.method_10264() != 0 || !((class_25862 = this.field_11863.method_8321(new class_2338((pos = pos.method_10081((class_2382)anchor)).method_10263(), this.field_11867.method_10264(), pos.method_10260()))) instanceof PulleyBlockEntity)) continue;
                    PulleyBlockEntity pbe = (PulleyBlockEntity)class_25862;
                    pbe.startMirroringOther(this.field_11867);
                }
            }
        }
        if (this.mirrorParent != null) {
            this.removeRopes();
        }
        this.clientOffsetDiff = 0.0f;
        this.running = true;
        this.sendData();
    }

    private void removeRopes() {
        for (int i = (int)this.offset; i > 0; --i) {
            class_2338 offset = this.field_11867.method_10087(i);
            class_2680 oldState = this.field_11863.method_8320(offset);
            this.field_11863.method_8652(offset, oldState.method_26227().method_15759(), 66);
        }
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null && this.mirrorParent == null) {
            return;
        }
        this.offset = this.getGridOffset(this.offset);
        if (this.movedContraption != null) {
            this.resetContraptionToOffset();
        }
        if (!this.field_11863.field_9236) {
            if (this.shouldCreateRopes()) {
                int i;
                if (this.offset > 0.0f) {
                    class_2338 magnetPos = this.field_11867.method_10087((int)this.offset);
                    class_3610 ifluidstate = this.field_11863.method_8316(magnetPos);
                    this.field_11863.method_22352(magnetPos, this.field_11863.method_8320(magnetPos).method_26220((class_1922)this.field_11863, magnetPos).method_1110());
                    this.field_11863.method_8652(magnetPos, (class_2680)AllBlocks.PULLEY_MAGNET.getDefaultState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(ifluidstate.method_15772() == class_3612.field_15910)), 66);
                }
                boolean[] waterlog = new boolean[(int)this.offset];
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    class_2338 ropePos = this.field_11867.method_10087(i);
                    class_3610 ifluidstate = this.field_11863.method_8316(ropePos);
                    waterlog[i] = ifluidstate.method_15772() == class_3612.field_15910;
                    this.field_11863.method_22352(ropePos, this.field_11863.method_8320(ropePos).method_26220((class_1922)this.field_11863, ropePos).method_1110());
                }
                for (i = 1; i <= (int)this.offset - 1; ++i) {
                    this.field_11863.method_8652(this.field_11867.method_10087(i), (class_2680)AllBlocks.ROPE.getDefaultState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterlog[i])), 66);
                }
            }
            if (this.movedContraption != null && this.mirrorParent == null) {
                this.movedContraption.disassemble();
            }
            this.notifyMirrorsOfDisassembly();
        }
        if (this.movedContraption != null) {
            this.movedContraption.method_31472();
        }
        this.movedContraption = null;
        this.initialOffset = 0;
        this.running = false;
        this.sendData();
    }

    protected boolean shouldCreateRopes() {
        return !this.field_11865;
    }

    @Override
    protected class_243 toPosition(float offset) {
        if (this.movedContraption.getContraption() instanceof PulleyContraption) {
            PulleyContraption contraption = (PulleyContraption)this.movedContraption.getContraption();
            return class_243.method_24954((class_2382)contraption.anchor).method_1031(0.0, (double)((float)contraption.getInitialOffset() - offset), 0.0);
        }
        return class_243.field_1353;
    }

    @Override
    protected void visitNewPosition() {
        super.visitNewPosition();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.movedContraption != null) {
            return;
        }
        if (this.getSpeed() <= 0.0f) {
            return;
        }
        class_2338 posBelow = this.field_11867.method_10087((int)(this.offset + this.getMovementSpeed()) + 1);
        class_2680 state = this.field_11863.method_8320(posBelow);
        if (!BlockMovementChecks.isMovementNecessary(state, this.field_11863, posBelow)) {
            return;
        }
        if (BlockMovementChecks.isBrittle(state)) {
            return;
        }
        this.disassemble();
        this.assembleNextTick = true;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.initialOffset = compound.method_10550("InitialOffset");
        this.needsContraption = compound.method_10577("NeedsContraption");
        super.read(compound, clientPacket);
        class_2338 prevMirrorParent = this.mirrorParent;
        this.mirrorParent = null;
        this.mirrorChildren = null;
        if (compound.method_10545("MirrorParent")) {
            this.mirrorParent = class_2512.method_10691((class_2487)compound.method_10562("MirrorParent"));
            this.offset = 0.0f;
            if (prevMirrorParent == null || !prevMirrorParent.equals((Object)this.mirrorParent)) {
                this.sharedMirrorContraption = null;
            }
        }
        if (compound.method_10545("MirrorChildren")) {
            this.mirrorChildren = NBTHelper.readCompoundList(compound.method_10554("MirrorChildren", 10), class_2512::method_10691);
        }
        if (this.mirrorParent == null) {
            this.sharedMirrorContraption = null;
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("InitialOffset", this.initialOffset);
        super.write(compound, clientPacket);
        if (this.mirrorParent != null) {
            compound.method_10566("MirrorParent", (class_2520)class_2512.method_10692((class_2338)this.mirrorParent));
        }
        if (this.mirrorChildren != null) {
            compound.method_10566("MirrorChildren", (class_2520)NBTHelper.writeCompoundList(this.mirrorChildren, class_2512::method_10692));
        }
    }

    public void startMirroringOther(class_2338 parent) {
        if (parent.equals((Object)this.field_11867)) {
            return;
        }
        class_2586 class_25862 = this.field_11863.method_8321(parent);
        if (!(class_25862 instanceof PulleyBlockEntity)) {
            return;
        }
        PulleyBlockEntity pbe = (PulleyBlockEntity)class_25862;
        if (pbe.method_11017() != this.method_11017()) {
            return;
        }
        if (pbe.mirrorChildren == null) {
            pbe.mirrorChildren = new ArrayList<class_2338>();
        }
        pbe.mirrorChildren.add(this.field_11867);
        pbe.notifyUpdate();
        this.mirrorParent = parent;
        try {
            this.assemble();
        }
        catch (AssemblyException assemblyException) {
            // empty catch block
        }
        this.notifyUpdate();
    }

    public void notifyMirrorsOfDisassembly() {
        if (this.mirrorChildren == null) {
            return;
        }
        for (class_2338 blockPos : this.mirrorChildren) {
            class_2586 class_25862 = this.field_11863.method_8321(blockPos);
            if (!(class_25862 instanceof PulleyBlockEntity)) continue;
            PulleyBlockEntity pbe = (PulleyBlockEntity)class_25862;
            pbe.offset = this.offset;
            pbe.disassemble();
            pbe.mirrorParent = null;
            pbe.notifyUpdate();
        }
        this.mirrorChildren.clear();
        this.notifyUpdate();
    }

    @Override
    protected int getExtensionRange() {
        return Math.max(0, Math.min((Integer)AllConfigs.server().kinetics.maxRopeLength.get(), this.field_11867.method_10264() - 1 - this.field_11863.method_31607()));
    }

    @Override
    protected int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    protected class_243 toMotionVector(float speed) {
        return new class_243(0.0, (double)(-speed), 0.0);
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new CenteredSideValueBoxTransform((state, d) -> d == class_2350.field_11036);
    }

    @Override
    public float getInterpolatedOffset(float partialTicks) {
        if (this.isVirtual()) {
            return class_3532.method_16439((float)partialTicks, (float)this.prevAnimatedOffset, (float)this.offset);
        }
        boolean moving = this.running && (this.movedContraption == null || !this.movedContraption.isStalled());
        return super.getInterpolatedOffset(moving ? partialTicks : 0.5f);
    }

    public void animateOffset(float forcedOffset) {
        this.offset = forcedOffset;
    }

    @Override
    public float getPercent() {
        int distance = this.field_11867.method_10264() - this.field_11863.method_31607();
        if (distance <= 0) {
            return 100.0f;
        }
        return 100.0f * this.getInterpolatedOffset(0.5f) / (float)distance;
    }

    public class_2338 getMirrorParent() {
        return this.mirrorParent;
    }
}

