/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.hosePulley;

import com.simibubi.create.content.fluids.hosePulley.HosePulleyBlock;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyFluidHandler;
import com.simibubi.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.simibubi.create.content.fluids.transfer.FluidFillingBehaviour;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class HosePulleyBlockEntity
extends KineticBlockEntity
implements SidedStorageBlockEntity {
    LerpedFloat offset = LerpedFloat.linear().startWithValue(0.0);
    boolean isMoving = true;
    private SmartFluidTank internalTank = new SmartFluidTank(243000L, this::onTankContentsChanged);
    private FluidDrainingBehaviour drainer;
    private FluidFillingBehaviour filler;
    private HosePulleyFluidHandler handler = new HosePulleyFluidHandler(this.internalTank, this.filler, this.drainer, () -> this.field_11867.method_10087((int)Math.ceil(this.offset.getValue())), () -> !this.isMoving);
    private boolean infinite;

    public HosePulleyBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void sendData() {
        this.infinite = this.filler.isInfinite() || this.drainer.isInfinite();
        super.sendData();
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean addToGoggleTooltip = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.infinite) {
            TooltipHelper.addHint(tooltip, "hint.hose_pulley", new Object[0]);
        }
        return addToGoggleTooltip;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.drainer = new FluidDrainingBehaviour(this);
        this.filler = new FluidFillingBehaviour(this);
        behaviours.add(this.drainer);
        behaviours.add(this.filler);
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.HOSE_PULLEY, AllAdvancements.HOSE_PULLEY_LAVA);
    }

    protected void onTankContentsChanged(FluidStack contents) {
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        this.isMoving = true;
        if (this.getSpeed() == 0.0f) {
            this.offset.forceNextSync();
            this.offset.setValue(Math.round(this.offset.getValue()));
            this.isMoving = false;
        }
        if (this.isMoving) {
            float newOffset = this.offset.getValue() + this.getMovementSpeed();
            if (newOffset < 0.0f) {
                this.isMoving = false;
            }
            if (!this.field_11863.method_8320(this.field_11867.method_10087((int)Math.ceil(newOffset))).method_45474()) {
                this.isMoving = false;
            }
            if (this.isMoving) {
                this.drainer.reset(null);
                this.filler.reset(null);
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0.0, (double)(-this.offset.getValue()), 0.0);
    }

    @Override
    public void tick() {
        super.tick();
        float newOffset = this.offset.getValue() + this.getMovementSpeed();
        if (newOffset < 0.0f) {
            newOffset = 0.0f;
            this.isMoving = false;
        }
        if (!this.field_11863.method_8320(this.field_11867.method_10087((int)Math.ceil(newOffset))).method_45474()) {
            newOffset = (int)newOffset;
            this.isMoving = false;
        }
        if (this.getSpeed() == 0.0f) {
            this.isMoving = false;
        }
        this.offset.setValue(newOffset);
        this.invalidateRenderBoundingBox();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.isMoving) {
            return;
        }
        int ceil = (int)Math.ceil(this.offset.getValue() + this.getMovementSpeed());
        if (this.getMovementSpeed() > 0.0f && this.field_11863.method_8320(this.field_11867.method_10087(ceil)).method_45474()) {
            this.isMoving = true;
            this.drainer.reset(null);
            this.filler.reset(null);
            return;
        }
        this.sendData();
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        if (clientPacket) {
            this.offset.forceNextSync();
        }
        compound.method_10566("Offset", (class_2520)this.offset.writeNBT());
        compound.method_10566("Tank", (class_2520)this.internalTank.writeToNBT(new class_2487()));
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.method_10556("Infinite", this.infinite);
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.offset.readNBT(compound.method_10562("Offset"), clientPacket);
        this.internalTank.readFromNBT(compound.method_10562("Tank"));
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.infinite = compound.method_10577("Infinite");
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
    }

    public float getMovementSpeed() {
        float movementSpeed = HosePulleyBlockEntity.convertToLinear(this.getSpeed());
        if (this.field_11863.field_9236) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }

    public float getInterpolatedOffset(float pt) {
        return this.offset.getValue(pt);
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        if (face == null || HosePulleyBlock.hasPipeTowards((class_4538)this.field_11863, this.field_11867, this.method_11010(), face)) {
            return this.handler;
        }
        return null;
    }
}

