/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.saw.SawBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;

public class SawRenderer
extends SafeBlockEntityRenderer<SawBlockEntity> {
    public SawRenderer(class_5614.class_5615 context) {
    }

    @Override
    protected void renderSafe(SawBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        this.renderBlade(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity(be, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((class_1937)be.method_10997())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderBlade(SawBlockEntity be, class_4587 ms, class_4597 buffer, int light) {
        PartialModel partial;
        class_2680 blockState = be.method_11010();
        float speed = be.getSpeed();
        boolean rotate = false;
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = be.getSpeed() > 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_REVERSED : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        SuperByteBuffer superBuffer = CachedBufferer.partialFacing(partial, blockState);
        if (rotate) {
            superBuffer.rotateCentered(class_2350.field_11036, AngleHelper.rad(90.0));
        }
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
    }

    protected void renderShaft(SawBlockEntity be, class_4587 ms, class_4597 buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer(be, this.getRotatedModel(be), ms, buffer.getBuffer(class_1921.method_23577()), light);
    }

    protected void renderItems(SawBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        boolean processingMode;
        boolean bl = processingMode = be.method_11010().method_11654((class_2769)SawBlock.FACING) == class_2350.field_11036;
        if (processingMode && !be.inventory.method_5442()) {
            boolean alongZ = (Boolean)be.method_11010().method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            ms.method_22903();
            boolean moving = be.inventory.recipeDuration != 0.0f;
            float offset = moving ? be.inventory.remainingTime / be.inventory.recipeDuration : 0.0f;
            float processingSpeed = class_3532.method_15363((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = class_3532.method_15363((float)(offset + (-partialTicks + 0.5f) * processingSpeed / be.inventory.recipeDuration), (float)0.125f, (float)1.0f);
                if (!be.inventory.appliedRecipe) {
                    offset += 1.0f;
                }
                offset /= 2.0f;
            }
            if (be.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (be.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < be.inventory.getSlotCount(); ++i) {
                class_1799 stack = be.inventory.getStackInSlot(i);
                if (stack.method_7960()) continue;
                class_918 itemRenderer = class_310.method_1551().method_1480();
                class_1087 modelWithOverrides = itemRenderer.method_4019(stack, be.method_10997(), null, 0);
                boolean blockItem = modelWithOverrides.method_4712();
                ms.method_22904(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.method_22905(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                }
                ms.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                itemRenderer.method_23178(stack, class_811.field_4319, light, overlay, ms, buffer, be.method_10997(), 0);
                break;
            }
            ms.method_22909();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        class_2680 state = be.method_11010();
        if (((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10166().method_10179()) {
            return CachedBufferer.partialFacing(AllPartialModels.SHAFT_HALF, state.method_26186(class_2470.field_11464));
        }
        return CachedBufferer.block(KineticBlockEntityRenderer.KINETIC_BLOCK, this.getRenderedBlockState(be));
    }

    protected class_2680 getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(be));
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        boolean shouldAnimate;
        class_2680 state = context.state;
        class_2350 facing = (class_2350)state.method_11654((class_2769)SawBlock.FACING);
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)SawBlock.FACING)).method_10163());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_2350 closestToFacing = class_2350.method_10142((double)facingVec.field_1352, (double)facingVec.field_1351, (double)facingVec.field_1350);
        boolean horizontal = closestToFacing.method_10166().method_10179();
        boolean backwards = VecHelper.isVecPointingTowards(context.relativeMotion, facing.method_10153());
        boolean moving = context.getAnimationSpeed() != 0.0f;
        boolean bl = shouldAnimate = context.contraption.stalled && horizontal || !context.contraption.stalled && !backwards && moving;
        SuperByteBuffer superBuffer = SawBlock.isHorizontal(state) ? (shouldAnimate ? CachedBufferer.partial(AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE, state) : CachedBufferer.partial(AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE, state)) : (shouldAnimate ? CachedBufferer.partial(AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE, state) : CachedBufferer.partial(AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE, state));
        ((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel()).centre()).rotateY(AngleHelper.horizontalAngle(facing))).rotateX(AngleHelper.verticalAngle(facing));
        if (!SawBlock.isHorizontal(state)) {
            superBuffer.rotateZ((Boolean)state.method_11654((class_2769)SawBlock.AXIS_ALONG_FIRST_COORDINATE) != false ? 90.0 : 0.0);
        }
        ((SuperByteBuffer)superBuffer.unCentre()).light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), buffer.getBuffer(class_1921.method_23579()));
    }
}

