/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.logistics.filter.AttributeFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterMenu;
import com.simibubi.create.content.logistics.filter.ItemAttribute;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.NetworkHooks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public class FilterItem
extends class_1792
implements class_3908 {
    private FilterType type;

    public static FilterItem regular(class_1792.class_1793 properties) {
        return new FilterItem(FilterType.REGULAR, properties);
    }

    public static FilterItem attribute(class_1792.class_1793 properties) {
        return new FilterItem(FilterType.ATTRIBUTE, properties);
    }

    private FilterItem(FilterType type, class_1792.class_1793 properties) {
        super(properties);
        this.type = type;
    }

    @Nonnull
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8036() == null) {
            return class_1269.field_5811;
        }
        return this.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        if (!AllKeys.shiftDown()) {
            List<class_2561> makeSummary = this.makeSummary(stack);
            if (makeSummary.isEmpty()) {
                return;
            }
            tooltip.add((class_2561)Components.literal(" "));
            tooltip.addAll(makeSummary);
        }
    }

    private List<class_2561> makeSummary(class_1799 filter) {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        if (!filter.method_7985()) {
            return list;
        }
        if (this.type == FilterType.REGULAR) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean blacklist = filter.method_7948().method_10577("Blacklist");
            list.add((class_2561)(blacklist ? Lang.translateDirect("gui.filter.deny_list", new Object[0]) : Lang.translateDirect("gui.filter.allow_list", new Object[0])).method_27692(class_124.field_1065));
            int count = 0;
            for (int i = 0; i < filterItems.getSlotCount(); ++i) {
                if (count > 3) {
                    list.add((class_2561)Components.literal("- ...").method_27692(class_124.field_1063));
                    break;
                }
                class_1799 filterStack = filterItems.getStackInSlot(i);
                if (filterStack.method_7960()) continue;
                list.add((class_2561)Components.literal("- ").method_10852(filterStack.method_7964()).method_27692(class_124.field_1080));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        if (this.type == FilterType.ATTRIBUTE) {
            AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[filter.method_7948().method_10550("WhitelistMode")];
            list.add((class_2561)(whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_CONJ ? Lang.translateDirect("gui.attribute_filter.allow_list_conjunctive", new Object[0]) : (whitelistMode == AttributeFilterMenu.WhitelistMode.WHITELIST_DISJ ? Lang.translateDirect("gui.attribute_filter.allow_list_disjunctive", new Object[0]) : Lang.translateDirect("gui.attribute_filter.deny_list", new Object[0]))).method_27692(class_124.field_1065));
            int count = 0;
            class_2499 attributes = filter.method_7948().method_10554("MatchedAttributes", 10);
            for (class_2520 inbt : attributes) {
                class_2487 compound = (class_2487)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                if (attribute == null) continue;
                boolean inverted = compound.method_10577("Inverted");
                if (count > 3) {
                    list.add((class_2561)Components.literal("- ...").method_27692(class_124.field_1063));
                    break;
                }
                list.add((class_2561)Components.literal("- ").method_10852((class_2561)attribute.format(inverted)));
                ++count;
            }
            if (count == 0) {
                return Collections.emptyList();
            }
        }
        return list;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 heldItem = player.method_5998(hand);
        if (!player.method_5715() && hand == class_1268.field_5808) {
            if (!world.field_9236 && player instanceof class_3222) {
                NetworkHooks.openScreen((class_3222)((class_3222)player), (class_3908)this, buf -> buf.method_10793(heldItem));
            }
            return class_1271.method_22427((Object)heldItem);
        }
        return class_1271.method_22430((Object)heldItem);
    }

    public class_1703 createMenu(int id, class_1661 inv, class_1657 player) {
        class_1799 heldItem = player.method_6047();
        if (this.type == FilterType.REGULAR) {
            return FilterMenu.create(id, inv, heldItem);
        }
        if (this.type == FilterType.ATTRIBUTE) {
            return AttributeFilterMenu.create(id, inv, heldItem);
        }
        return null;
    }

    public class_2561 method_5476() {
        return this.method_7848();
    }

    public static ItemStackHandler getFilterItems(class_1799 stack) {
        ItemStackHandler newInv = new ItemStackHandler(18);
        if (AllItems.FILTER.get() != stack.method_7909()) {
            throw new IllegalArgumentException("Cannot get filter items from non-filter: " + String.valueOf(stack));
        }
        if (!stack.method_7985()) {
            return newInv;
        }
        class_2487 invNBT = stack.method_7911("Items");
        if (!invNBT.method_33133()) {
            newInv.deserializeNBT(invNBT);
        }
        return newInv;
    }

    public static boolean test(class_1937 world, class_1799 stack, class_1799 filter) {
        return FilterItem.test(world, stack, filter, false);
    }

    public static boolean test(class_1937 world, FluidStack stack, class_1799 filter) {
        return FilterItem.test(world, stack, filter, true);
    }

    public static boolean test(class_1937 world, class_1799 stack, class_1799 filter, boolean matchNBT) {
        boolean defaults;
        if (filter.method_7960()) {
            return true;
        }
        if (!(filter.method_7909() instanceof FilterItem)) {
            return FilterItem.testDirect(filter, stack, matchNBT);
        }
        boolean bl = defaults = !filter.method_7985();
        if (defaults) {
            return FilterItem.testDirect(filter, stack, matchNBT);
        }
        if (AllItems.FILTER.get() == filter.method_7909()) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean respectNBT = defaults ? false : filter.method_7969().method_10577("RespectNBT");
            boolean blacklist = defaults ? false : filter.method_7969().method_10577("Blacklist");
            boolean isEmpty = true;
            for (int slot = 0; slot < filterItems.getSlotCount(); ++slot) {
                class_1799 stackInSlot = filterItems.getStackInSlot(slot);
                if (stackInSlot.method_7960()) continue;
                isEmpty = false;
                boolean matches = FilterItem.test(world, stack, stackInSlot, respectNBT);
                if (!matches) continue;
                return !blacklist;
            }
            if (isEmpty) {
                return FilterItem.testDirect(filter, stack, matchNBT);
            }
            return blacklist;
        }
        if (AllItems.ATTRIBUTE_FILTER.get() == filter.method_7909()) {
            class_2499 attributes;
            class_2499 class_24992 = attributes = defaults ? new class_2499() : filter.method_7969().method_10554("MatchedAttributes", 10);
            if (attributes.isEmpty()) {
                return FilterItem.testDirect(filter, stack, matchNBT);
            }
            AttributeFilterMenu.WhitelistMode whitelistMode = AttributeFilterMenu.WhitelistMode.values()[defaults ? 0 : filter.method_7969().method_10550("WhitelistMode")];
            block16: for (class_2520 inbt : attributes) {
                boolean matches;
                class_2487 compound = (class_2487)inbt;
                ItemAttribute attribute = ItemAttribute.fromNBT(compound);
                if (attribute == null) continue;
                boolean bl2 = matches = attribute.appliesTo(stack, world) != compound.method_10577("Inverted");
                if (matches) {
                    switch (whitelistMode) {
                        case BLACKLIST: {
                            return false;
                        }
                        case WHITELIST_CONJ: {
                            continue block16;
                        }
                        case WHITELIST_DISJ: {
                            return true;
                        }
                    }
                    continue;
                }
                switch (whitelistMode) {
                    case BLACKLIST: {
                        continue block16;
                    }
                    case WHITELIST_CONJ: {
                        return false;
                    }
                    case WHITELIST_DISJ: {
                        continue block16;
                    }
                }
            }
            switch (whitelistMode) {
                case BLACKLIST: {
                    return true;
                }
                case WHITELIST_CONJ: {
                    return true;
                }
                case WHITELIST_DISJ: {
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean test(class_1937 world, FluidStack stack, class_1799 filter, boolean matchNBT) {
        boolean defaults;
        if (filter.method_7960()) {
            return true;
        }
        if (stack.isEmpty()) {
            return false;
        }
        if (!(filter.method_7909() instanceof FilterItem)) {
            if (!GenericItemEmptying.canItemBeEmptied(world, filter)) {
                return false;
            }
            FluidStack fluidInFilter = GenericItemEmptying.emptyItem(world, filter, true).getFirst();
            if (fluidInFilter == null) {
                return false;
            }
            if (!matchNBT) {
                return fluidInFilter.getFluid().method_15780(stack.getFluid());
            }
            boolean fluidEqual = fluidInFilter.isFluidEqual(stack);
            return fluidEqual;
        }
        boolean bl = defaults = !filter.method_7985();
        if (AllItems.FILTER.get() == filter.method_7909()) {
            ItemStackHandler filterItems = FilterItem.getFilterItems(filter);
            boolean respectNBT = defaults ? false : filter.method_7969().method_10577("RespectNBT");
            boolean blacklist = defaults ? false : filter.method_7969().method_10577("Blacklist");
            for (int slot = 0; slot < filterItems.getSlotCount(); ++slot) {
                boolean matches;
                class_1799 stackInSlot = filterItems.getStackInSlot(slot);
                if (stackInSlot.method_7960() || !(matches = FilterItem.test(world, stack, stackInSlot, respectNBT))) continue;
                return !blacklist;
            }
            return blacklist;
        }
        return false;
    }

    private static boolean testDirect(class_1799 filter, class_1799 stack, boolean matchNBT) {
        if (matchNBT) {
            return ItemHandlerHelper.canItemStacksStack((class_1799)filter, (class_1799)stack);
        }
        return ItemHelper.sameItem(filter, stack);
    }

    private static enum FilterType {
        REGULAR,
        ATTRIBUTE;

    }
}

