/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.burner;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlockItem;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.AdventureUtil;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_201;
import net.minecraft.class_212;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_77;
import net.minecraft.class_85;

@class_6328
@ParametersAreNonnullByDefault
public class BlazeBurnerBlock
extends class_2383
implements IBE<BlazeBurnerBlockEntity>,
IWrenchable {
    public static final class_2754<HeatLevel> HEAT_LEVEL = class_2754.method_11850((String)"blaze", HeatLevel.class);

    public BlazeBurnerBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)this.method_9564().method_11657(HEAT_LEVEL, (Comparable)((Object)HeatLevel.NONE)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{HEAT_LEVEL, field_11177});
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 p_220082_4_, boolean p_220082_5_) {
        if (world.field_9236) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos.method_10084());
        if (!(blockEntity instanceof BasinBlockEntity)) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
        basin.notifyChangeOfContents();
    }

    @Override
    public Class<BlazeBurnerBlockEntity> getBlockEntityClass() {
        return BlazeBurnerBlockEntity.class;
    }

    @Override
    public class_2591<? extends BlazeBurnerBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.HEATER.get();
    }

    @Override
    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(HEAT_LEVEL) == HeatLevel.NONE) {
            return null;
        }
        return IBE.super.method_10123(pos, state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 blockRayTraceResult) {
        class_1799 heldItem = player.method_5998(hand);
        HeatLevel heat = (HeatLevel)((Object)state.method_11654(HEAT_LEVEL));
        if (AllItems.GOGGLES.isIn(heldItem) && heat != HeatLevel.NONE) {
            return this.onBlockEntityUse((class_1922)world, pos, bbte -> {
                if (bbte.goggles) {
                    return class_1269.field_5811;
                }
                bbte.goggles = true;
                bbte.notifyUpdate();
                return class_1269.field_5812;
            });
        }
        if (AdventureUtil.isAdventure(player)) {
            return class_1269.field_5811;
        }
        if (heldItem.method_7960() && heat != HeatLevel.NONE) {
            return this.onBlockEntityUse((class_1922)world, pos, bbte -> {
                if (!bbte.goggles) {
                    return class_1269.field_5811;
                }
                bbte.goggles = false;
                bbte.notifyUpdate();
                return class_1269.field_5812;
            });
        }
        if (heat == HeatLevel.NONE) {
            if (heldItem.method_7909() instanceof class_1786) {
                world.method_8396(player, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.4f + 0.8f);
                if (world.field_9236) {
                    return class_1269.field_5812;
                }
                heldItem.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                world.method_8501(pos, AllBlocks.LIT_BLAZE_BURNER.getDefaultState());
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        boolean doNotConsume = player.method_7337();
        boolean forceOverflow = !player.isFake();
        try (Transaction t = TransferUtil.getTransaction();){
            class_1271<class_1799> res = BlazeBurnerBlock.tryInsert(state, world, pos, heldItem, doNotConsume, forceOverflow, (TransactionContext)t);
            t.commit();
            class_1799 leftover = (class_1799)res.method_5466();
            if (!(world.field_9236 || doNotConsume || leftover.method_7960())) {
                if (heldItem.method_7960()) {
                    player.method_6122(hand, leftover);
                } else if (!player.method_31548().method_7394(leftover)) {
                    player.method_7328(leftover, false);
                }
            }
            class_1269 class_12692 = res.method_5467() == class_1269.field_5812 ? class_1269.field_5812 : class_1269.field_5811;
            return class_12692;
        }
    }

    public static class_1271<class_1799> tryInsert(class_2680 state, class_1937 world, class_2338 pos, class_1799 stack, boolean doNotConsume, boolean forceOverflow, TransactionContext ctx) {
        if (!state.method_31709()) {
            return class_1271.method_22431((Object)class_1799.field_8037);
        }
        class_2586 be = world.method_8321(pos);
        if (!(be instanceof BlazeBurnerBlockEntity)) {
            return class_1271.method_22431((Object)class_1799.field_8037);
        }
        BlazeBurnerBlockEntity burnerBE = (BlazeBurnerBlockEntity)be;
        if (burnerBE.isCreativeFuel(stack)) {
            TransactionCallback.onSuccess((TransactionContext)ctx, burnerBE::applyCreativeFuel);
            return class_1271.method_22427((Object)class_1799.field_8037);
        }
        if (!burnerBE.tryUpdateFuel(stack, forceOverflow, ctx)) {
            return class_1271.method_22431((Object)class_1799.field_8037);
        }
        if (!doNotConsume) {
            class_1799 container = stack.getRecipeRemainder();
            if (!world.field_9236) {
                stack.method_7934(1);
            }
            return class_1271.method_22427((Object)container);
        }
        return class_1271.method_22427((Object)class_1799.field_8037);
    }

    public class_2680 method_9605(class_1750 context) {
        class_1799 stack = context.method_8041();
        class_1792 item = stack.method_7909();
        class_2680 defaultState = this.method_9564();
        if (!(item instanceof BlazeBurnerBlockItem)) {
            return defaultState;
        }
        HeatLevel initialHeat = ((BlazeBurnerBlockItem)item).hasCapturedBlaze() ? HeatLevel.SMOULDERING : HeatLevel.NONE;
        return (class_2680)((class_2680)defaultState.method_11657(HEAT_LEVEL, (Comparable)((Object)initialHeat))).method_11657((class_2769)field_11177, (Comparable)context.method_8042().method_10153());
    }

    public class_265 method_9530(class_2680 state, class_1922 reader, class_2338 pos, class_3726 context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public class_265 method_9549(class_2680 p_220071_1_, class_1922 p_220071_2_, class_2338 p_220071_3_, class_3726 p_220071_4_) {
        if (p_220071_4_ == class_3726.method_16194()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.method_9530(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean method_9498(class_2680 p_149740_1_) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 p_180641_2_, class_2338 p_180641_3_) {
        return Math.max(0, ((HeatLevel)((Object)state.method_11654(HEAT_LEVEL))).ordinal() - 1);
    }

    public boolean method_9516(class_2680 state, class_1922 reader, class_2338 pos, class_10 type) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(10) != 0) {
            return;
        }
        if (!((HeatLevel)((Object)state.method_11654(HEAT_LEVEL))).isAtLeast(HeatLevel.SMOULDERING)) {
            return;
        }
        world.method_8486((double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.5f), (double)((float)pos.method_10260() + 0.5f), class_3417.field_17483, class_3419.field_15245, 0.5f + random.method_43057(), random.method_43057() * 0.7f + 0.6f, false);
    }

    public static HeatLevel getHeatLevelOf(class_2680 blockState) {
        return blockState.method_28498(HEAT_LEVEL) ? (HeatLevel)((Object)blockState.method_11654(HEAT_LEVEL)) : HeatLevel.NONE;
    }

    public static int getLight(class_2680 state) {
        HeatLevel level = (HeatLevel)((Object)state.method_11654(HEAT_LEVEL));
        return switch (level.ordinal()) {
            case 0 -> 0;
            case 1 -> 8;
            default -> 15;
        };
    }

    public static class_52.class_53 buildLootTable() {
        class_5341.class_210 survivesExplosion = class_201.method_871();
        BlazeBurnerBlock block = (BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get();
        class_52.class_53 builder = class_52.method_324();
        class_55.class_56 poolBuilder = class_55.method_347();
        for (HeatLevel level : HeatLevel.values()) {
            class_1935 drop = level == HeatLevel.NONE ? (class_1935)AllItems.EMPTY_BLAZE_BURNER.get() : (class_1935)AllBlocks.BLAZE_BURNER.get();
            poolBuilder.method_351(((class_85.class_86)class_77.method_411((class_1935)drop).method_421(survivesExplosion)).method_421((class_5341.class_210)class_212.method_900((class_2248)block).method_22584(class_4559.class_4560.method_22523().method_22525(HEAT_LEVEL, (Comparable)((Object)level)))));
        }
        builder.method_336(poolBuilder.method_352((class_5658)class_44.method_32448((float)1.0f)));
        return builder;
    }

    public static enum HeatLevel implements class_3542
    {
        NONE,
        SMOULDERING,
        FADING,
        KINDLED,
        SEETHING;


        public static HeatLevel byIndex(int index) {
            return HeatLevel.values()[index];
        }

        public HeatLevel nextActiveLevel() {
            return HeatLevel.byIndex(this.ordinal() % (HeatLevel.values().length - 1) + 1);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public String method_15434() {
            return Lang.asId(this.name());
        }
    }
}

