/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllBogeyStyles;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.content.trains.bogey.BogeyStyle;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4970;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBogeyBlock<T extends AbstractBogeyBlockEntity>
extends class_2248
implements IBE<T>,
ProperWaterloggedBlock,
ISpecialBlockItemRequirement,
IWrenchable {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    static final List<class_2960> BOGEYS = new ArrayList<class_2960>();
    public BogeySizes.BogeySize size;
    static final EnumSet<class_2350> STICKY_X = EnumSet.of(class_2350.field_11034, class_2350.field_11039);
    static final EnumSet<class_2350> STICKY_Z = EnumSet.of(class_2350.field_11035, class_2350.field_11043);

    public AbstractBogeyBlock(class_4970.class_2251 pProperties, BogeySizes.BogeySize size) {
        super(pProperties);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.size = size;
    }

    public boolean isOnIncompatibleTrack(Carriage carriage, boolean leading) {
        TravellingPoint point = leading ? carriage.getLeadingPoint() : carriage.getTrailingPoint();
        CarriageBogey bogey = leading ? carriage.leadingBogey() : carriage.trailingBogey();
        return point.edge.getTrackMaterial().trackType != this.getTrackType(bogey.getStyle());
    }

    public Set<TrackMaterial.TrackType> getValidPathfindingTypes(BogeyStyle style) {
        return ImmutableSet.of((Object)this.getTrackType(style));
    }

    public abstract TrackMaterial.TrackType getTrackType(BogeyStyle var1);

    @Deprecated
    public static void registerStandardBogey(class_2960 block) {
        BOGEYS.add(block);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS, WATERLOGGED});
        super.method_9515(builder);
    }

    public class_2680 method_9559(class_2680 pState, class_2350 pDirection, class_2680 pNeighborState, class_1936 pLevel, class_2338 pCurrentPos, class_2338 pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public class_3610 method_9545(class_2680 pState) {
        return this.fluidState(pState);
    }

    public EnumSet<class_2350> getStickySurfaces(class_1922 world, class_2338 pos, class_2680 state) {
        return state.method_11654((class_2769)class_2741.field_12529) == class_2350.class_2351.field_11048 ? STICKY_X : STICKY_Z;
    }

    public abstract double getWheelPointSpacing();

    public abstract double getWheelRadius();

    public class_243 getConnectorAnchorOffset(boolean upsideDown) {
        return this.getConnectorAnchorOffset();
    }

    protected abstract class_243 getConnectorAnchorOffset();

    public boolean allowsSingleBogeyCarriage() {
        return true;
    }

    public abstract BogeyStyle getDefaultStyle();

    public boolean captureBlockEntityForTrain() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void render(@Nullable class_2680 state, float wheelAngle, class_4587 ms, float partialTicks, class_4597 buffers, int light, int overlay, BogeyStyle style, class_2487 bogeyData) {
        if (style == null) {
            style = this.getDefaultStyle();
        }
        Optional<BogeyRenderer.CommonRenderer> commonRenderer = style.getInWorldCommonRenderInstance();
        BogeyRenderer renderer = style.getInWorldRenderInstance(this.getSize());
        if (state != null) {
            ms.method_46416(0.5f, 0.5f, 0.5f);
            if (state.method_11654(AXIS) == class_2350.class_2351.field_11048) {
                ms.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            }
        }
        ms.method_22904(0.0, -1.5078125, 0.0);
        class_4588 vb = buffers.getBuffer(class_1921.method_23579());
        if (bogeyData == null) {
            bogeyData = new class_2487();
        }
        renderer.render(bogeyData, wheelAngle, ms, light, vb, state == null);
        class_2487 finalBogeyData = bogeyData;
        commonRenderer.ifPresent(common -> common.render(finalBogeyData, wheelAngle, ms, light, vb, state == null));
    }

    public BogeySizes.BogeySize getSize() {
        return this.size;
    }

    public class_2350 getBogeyUpDirection() {
        return class_2350.field_11036;
    }

    public boolean isTrackAxisAlongFirstCoordinate(class_2680 state) {
        return state.method_11654(AXIS) == class_2350.class_2351.field_11048;
    }

    @Nullable
    public class_2680 getMatchingBogey(class_2350 upDirection, boolean axisAlongFirst) {
        if (upDirection != class_2350.field_11036) {
            return null;
        }
        return (class_2680)this.method_9564().method_11657(AXIS, (Comparable)(axisAlongFirst ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051));
    }

    public final class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level.field_9236) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (!player.method_5715() && stack.method_31574((class_1792)AllItems.WRENCH.get()) && !player.method_7357().method_7904(stack.method_7909()) && AllBogeyStyles.BOGEY_STYLES.size() > 1) {
            class_2586 be = level.method_8321(pos);
            if (!(be instanceof AbstractBogeyBlockEntity)) {
                return class_1269.field_5814;
            }
            AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)be;
            player.method_7357().method_7906(stack.method_7909(), 20);
            BogeyStyle currentStyle = sbbe.getStyle();
            BogeySizes.BogeySize size = this.getSize();
            BogeyStyle style = this.getNextStyle(currentStyle);
            if (style == currentStyle) {
                return class_1269.field_5811;
            }
            Set<BogeySizes.BogeySize> validSizes = style.validSizes();
            for (int i = 0; i < BogeySizes.count() && !validSizes.contains(size); ++i) {
                size = size.increment();
            }
            sbbe.setBogeyStyle(style);
            class_2487 defaultData = style.defaultData;
            sbbe.setBogeyData(sbbe.getBogeyData().method_10543(defaultData));
            if (size == this.getSize()) {
                player.method_7353((class_2561)Lang.translateDirect("bogey.style.updated_style", new Object[0]).method_27693(": ").method_10852(style.displayName), true);
            } else {
                class_2487 oldData = sbbe.getBogeyData();
                level.method_8652(pos, this.getStateOfSize(sbbe, size), 3);
                class_2586 newBlockEntity = level.method_8321(pos);
                if (!(newBlockEntity instanceof AbstractBogeyBlockEntity)) {
                    return class_1269.field_5814;
                }
                AbstractBogeyBlockEntity newBlockEntity1 = (AbstractBogeyBlockEntity)newBlockEntity;
                newBlockEntity1.setBogeyData(oldData);
                player.method_7353((class_2561)Lang.translateDirect("bogey.style.updated_style_and_size", new Object[0]).method_27693(": ").method_10852(style.displayName), true);
            }
            return class_1269.field_21466;
        }
        return this.onInteractWithBogey(state, level, pos, player, hand, hit);
    }

    protected class_1269 onInteractWithBogey(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        return class_1269.field_5811;
    }

    protected List<class_2960> getBogeyBlockCycle() {
        return BOGEYS;
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 state, class_2350 targetedFace) {
        class_2248 block = state.method_26204();
        List<class_2960> bogeyCycle = this.getBogeyBlockCycle();
        int indexOf = bogeyCycle.indexOf(RegisteredObjects.getKeyOrThrow(block));
        if (indexOf == -1) {
            return state;
        }
        int index = (indexOf + 1) % bogeyCycle.size();
        class_2350 bogeyUpDirection = this.getBogeyUpDirection();
        boolean trackAxisAlongFirstCoordinate = this.isTrackAxisAlongFirstCoordinate(state);
        while (index != indexOf) {
            AbstractBogeyBlock bogey;
            class_2680 matchingBogey;
            class_2960 id = bogeyCycle.get(index);
            class_2248 newBlock = (class_2248)class_7923.field_41175.method_10223(id);
            if (newBlock instanceof AbstractBogeyBlock && (matchingBogey = (bogey = (AbstractBogeyBlock)newBlock).getMatchingBogey(bogeyUpDirection, trackAxisAlongFirstCoordinate)) != null) {
                return this.copyProperties(state, matchingBogey);
            }
            index = (index + 1) % bogeyCycle.size();
        }
        return state;
    }

    public class_2680 getNextSize(class_1937 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (be instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)be;
            return this.getNextSize(sbbe);
        }
        return level.method_8320(pos);
    }

    public List<class_2769<?>> propertiesToCopy() {
        return ImmutableList.of((Object)WATERLOGGED, AXIS);
    }

    private <V extends Comparable<V>> class_2680 copyProperty(class_2680 source, class_2680 target, class_2769<V> property) {
        if (source.method_28498(property) && target.method_28498(property)) {
            return (class_2680)target.method_11657(property, source.method_11654(property));
        }
        return target;
    }

    private class_2680 copyProperties(class_2680 source, class_2680 target) {
        for (class_2769<?> property : this.propertiesToCopy()) {
            target = this.copyProperty(source, target, property);
        }
        return target;
    }

    public class_2680 getNextSize(AbstractBogeyBlockEntity sbte) {
        BogeySizes.BogeySize size = this.getSize();
        BogeyStyle style = sbte.getStyle();
        class_2680 nextBlock = style.getNextBlock(size).method_9564();
        nextBlock = this.copyProperties(sbte.method_11010(), nextBlock);
        return nextBlock;
    }

    public class_2680 getStateOfSize(AbstractBogeyBlockEntity sbte, BogeySizes.BogeySize size) {
        BogeyStyle style = sbte.getStyle();
        class_2680 state = style.getBlockOfSize(size).method_9564();
        return this.copyProperties(sbte.method_11010(), state);
    }

    public BogeyStyle getNextStyle(class_1937 level, class_2338 pos) {
        class_2586 te = level.method_8321(pos);
        if (te instanceof AbstractBogeyBlockEntity) {
            AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)te;
            return this.getNextStyle(sbbe.getStyle());
        }
        return this.getDefaultStyle();
    }

    public BogeyStyle getNextStyle(BogeyStyle style) {
        Collection<BogeyStyle> allStyles = style.getCycleGroup().values();
        if (allStyles.size() <= 1) {
            return style;
        }
        ArrayList<BogeyStyle> list = new ArrayList<BogeyStyle>(allStyles);
        return Iterate.cycleValue(list, style);
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 pState, class_2470 pRotation) {
        return switch (pRotation) {
            case class_2470.field_11465, class_2470.field_11463 -> (class_2680)pState.method_28493(AXIS);
            default -> pState;
        };
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 te) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, AllBlocks.RAILWAY_CASING.asStack());
    }

    public boolean canBeUpsideDown() {
        return false;
    }

    public boolean isUpsideDown(class_2680 state) {
        return false;
    }

    public class_2680 getVersion(class_2680 base, boolean upsideDown) {
        return base;
    }
}

