/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllPackets;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlockEntity;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.entity.TrainMigration;
import com.simibubi.create.content.trains.entity.TrainPacket;
import com.simibubi.create.content.trains.entity.TrainStatus;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgeData;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.observer.TrackObserver;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBoundary;
import com.simibubi.create.content.trains.signal.SignalEdgeGroup;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.pepperbell.simplenetworking.S2CPacket;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class Train {
    public double speed = 0.0;
    public double targetSpeed = 0.0;
    public Double speedBeforeStall = null;
    public int carriageWaitingForChunks = -1;
    public double throttle = 1.0;
    public boolean honk = false;
    public UUID id;
    @Nullable
    public UUID owner;
    public TrackGraph graph;
    public Navigation navigation;
    public ScheduleRuntime runtime;
    public TrainIconType icon;
    public class_2561 name;
    public TrainStatus status;
    public boolean invalid;
    public TravellingPoint.SteerDirection manualSteer;
    public boolean manualTick;
    public UUID currentStation;
    public boolean currentlyBackwards;
    public boolean doubleEnded;
    public List<Carriage> carriages;
    public List<Integer> carriageSpacing;
    public boolean updateSignalBlocks;
    public Map<UUID, UUID> occupiedSignalBlocks;
    public Set<UUID> reservedSignalBlocks;
    public Set<UUID> occupiedObservers;
    public Map<UUID, Pair<Integer, Boolean>> cachedObserverFiltering;
    List<TrainMigration> migratingPoints;
    public int migrationCooldown;
    public boolean derailed;
    public int fuelTicks;
    public int honkTicks;
    public Boolean lowHonk;
    public int honkPitch;
    public float accumulatedSteamRelease;
    int tickOffset;
    double[] stress;
    public class_1657 backwardsDriver;

    public Train(UUID id, UUID owner, TrackGraph graph, List<Carriage> carriages, List<Integer> carriageSpacing, boolean doubleEnded) {
        this.id = id;
        this.owner = owner;
        this.graph = graph;
        this.carriages = carriages;
        this.carriageSpacing = carriageSpacing;
        this.icon = TrainIconType.getDefault();
        this.stress = new double[carriageSpacing.size()];
        this.name = Lang.translateDirect("train.unnamed", new Object[0]);
        this.status = new TrainStatus(this);
        this.doubleEnded = doubleEnded;
        carriages.forEach(c -> c.setTrain(this));
        this.navigation = new Navigation(this);
        this.runtime = new ScheduleRuntime(this);
        this.migratingPoints = new ArrayList<TrainMigration>();
        this.currentStation = null;
        this.manualSteer = TravellingPoint.SteerDirection.NONE;
        this.occupiedSignalBlocks = new HashMap<UUID, UUID>();
        this.reservedSignalBlocks = new HashSet<UUID>();
        this.occupiedObservers = new HashSet<UUID>();
        this.cachedObserverFiltering = new HashMap<UUID, Pair<Integer, Boolean>>();
        this.tickOffset = Create.RANDOM.nextInt(100);
    }

    public void earlyTick(class_1937 level) {
        this.status.tick(level);
        if (this.graph == null && !this.migratingPoints.isEmpty()) {
            this.reattachToTracks(level);
        }
        if (this.graph == null) {
            this.addToSignalGroups(this.occupiedSignalBlocks.keySet());
            return;
        }
        if (this.updateSignalBlocks) {
            this.updateSignalBlocks = false;
            this.collectInitiallyOccupiedSignalBlocks();
        }
        this.addToSignalGroups(this.occupiedSignalBlocks.keySet());
        this.addToSignalGroups(this.reservedSignalBlocks);
        if (this.occupiedObservers.isEmpty()) {
            return;
        }
        this.tickOccupiedObservers(level);
    }

    private void tickOccupiedObservers(class_1937 level) {
        int storageVersion = 0;
        for (Carriage carriage : this.carriages) {
            storageVersion += carriage.storage.getVersion();
        }
        for (UUID uuid : this.occupiedObservers) {
            TrackObserver observer = this.graph.getPoint(EdgePointType.OBSERVER, uuid);
            if (observer == null) continue;
            class_1799 filter = observer.getFilter();
            if (filter.method_7960()) {
                observer.keepAlive(this);
                continue;
            }
            Pair cachedMatch = this.cachedObserverFiltering.computeIfAbsent(uuid, $ -> Pair.of(-1, false));
            boolean shouldActivate = (Boolean)cachedMatch.getSecond();
            if ((Integer)cachedMatch.getFirst() == storageVersion) {
                if (!shouldActivate) continue;
                observer.keepAlive(this);
                continue;
            }
            shouldActivate = false;
            for (Carriage carriage : this.carriages) {
                if (shouldActivate) break;
                Contraption.ContraptionInvWrapper inv = carriage.storage.getItems();
                CombinedTankWrapper tank = carriage.storage.getFluids();
                Transaction t = TransferUtil.getTransaction();
                try {
                    shouldActivate = StorageUtil.findExtractableResource((Storage)inv, variant -> FilterItem.test(level, variant.toStack(), filter), (TransactionContext)t) != null || StorageUtil.findExtractableResource((Storage)tank, variant -> FilterItem.test(level, new FluidStack(variant, 1L), filter), (TransactionContext)t) != null;
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            this.cachedObserverFiltering.put(uuid, Pair.of(storageVersion, shouldActivate));
            if (!shouldActivate) continue;
            observer.keepAlive(this);
        }
    }

    private void addToSignalGroups(Collection<UUID> groups) {
        Map<UUID, SignalEdgeGroup> groupMap = Create.RAILWAYS.signalEdgeGroups;
        Iterator<UUID> iterator = groups.iterator();
        while (iterator.hasNext()) {
            SignalEdgeGroup signalEdgeGroup = groupMap.get(iterator.next());
            if (signalEdgeGroup == null) {
                iterator.remove();
                continue;
            }
            signalEdgeGroup.trains.add(this);
        }
    }

    public void tick(class_1937 level) {
        Create.RAILWAYS.markTracksDirty();
        if (this.graph == null) {
            this.carriages.forEach(c -> c.manageEntities(level));
            this.updateConductors();
            return;
        }
        this.updateConductors();
        this.runtime.tick(level);
        this.navigation.tick(level);
        this.tickPassiveSlowdown();
        if (this.derailed) {
            this.tickDerailedSlowdown();
        }
        double distance = this.speed;
        Carriage previousCarriage = null;
        int carriageCount = this.carriages.size();
        boolean stalled = false;
        double maxStress = 0.0;
        if (this.carriageWaitingForChunks != -1) {
            distance = 0.0;
        }
        for (int i = 0; i < carriageCount; ++i) {
            Carriage carriage = this.carriages.get(i);
            if (previousCarriage != null) {
                int target = this.carriageSpacing.get(i - 1);
                double actual = target;
                TravellingPoint leadingPoint = carriage.getLeadingPoint();
                TravellingPoint trailingPoint = previousCarriage.getTrailingPoint();
                int entries = 0;
                double total = 0.0;
                if (leadingPoint.node1 != null && trailingPoint.node1 != null) {
                    class_5321<class_1937> d1 = leadingPoint.node1.getLocation().dimension;
                    class_5321<class_1937> d2 = trailingPoint.node1.getLocation().dimension;
                    for (boolean b : Iterate.trueAndFalse) {
                        class_5321<class_1937> d;
                        class_5321<class_1937> class_53212 = d = b ? d1 : d2;
                        if (!b && d1.equals(d2) || !d1.equals(d2)) continue;
                        Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensionalIfPresent(d);
                        Carriage.DimensionalCarriageEntity dimensional2 = previousCarriage.getDimensionalIfPresent(d);
                        if (dimensional == null || dimensional2 == null) continue;
                        class_243 leadingAnchor = dimensional.leadingAnchor();
                        class_243 trailingAnchor = dimensional2.trailingAnchor();
                        if (leadingAnchor == null || trailingAnchor == null) continue;
                        double distanceTo = leadingAnchor.method_1025(trailingAnchor);
                        distanceTo = carriage.leadingBogey().isUpsideDown() != previousCarriage.trailingBogey().isUpsideDown() ? Math.sqrt(distanceTo - 4.0) : Math.sqrt(distanceTo);
                        total += distanceTo;
                        ++entries;
                    }
                }
                if (entries > 0) {
                    actual = total / (double)entries;
                }
                this.stress[i - 1] = (double)target - actual;
                maxStress = Math.max(maxStress, Math.abs((double)target - actual));
            }
            previousCarriage = carriage;
            if (!carriage.stalled) continue;
            if (this.speedBeforeStall == null) {
                this.speedBeforeStall = this.speed;
            }
            distance = 0.0;
            this.speed = 0.0;
            stalled = true;
        }
        if (!stalled && this.speedBeforeStall != null) {
            this.speed = class_3532.method_15350((double)this.speedBeforeStall, (double)-1.0, (double)1.0);
            this.speedBeforeStall = null;
        }
        boolean approachingStation = this.navigation.distanceToDestination < 5.0;
        double leadingModifier = approachingStation ? 0.75 : 0.5;
        double trailingModifier = approachingStation ? 0.0 : 0.125;
        boolean blocked = false;
        boolean iterateFromBack = this.speed < 0.0;
        for (int index = 0; index < carriageCount; ++index) {
            boolean last;
            double leadingStress;
            int i;
            int n = i = iterateFromBack ? carriageCount - 1 - index : index;
            double d = i == 0 ? 0.0 : (leadingStress = this.stress[i - 1] * -(iterateFromBack ? trailingModifier : leadingModifier));
            double trailingStress = i == this.stress.length ? 0.0 : this.stress[i] * (iterateFromBack ? leadingModifier : trailingModifier);
            Carriage carriage = this.carriages.get(i);
            TravellingPoint toFollowForward = i == 0 ? null : this.carriages.get(i - 1).getTrailingPoint();
            TravellingPoint toFollowBackward = i == carriageCount - 1 ? null : this.carriages.get(i + 1).getLeadingPoint();
            double totalStress = this.derailed ? 0.0 : leadingStress + trailingStress;
            boolean first = i == 0;
            boolean bl = last = i == carriageCount - 1;
            int carriageType = first ? (last ? 3 : 0) : (last ? 2 : 1);
            double actualDistance = carriage.travel(level, this.graph, distance + totalStress, toFollowForward, toFollowBackward, carriageType);
            blocked |= carriage.blocked || carriage.isOnIncompatibleTrack();
            boolean onTwoBogeys = carriage.isOnTwoBogeys();
            maxStress = Math.max(maxStress, onTwoBogeys ? (double)carriage.bogeySpacing - carriage.getAnchorDiff() : 0.0);
            maxStress = Math.max(maxStress, carriage.leadingBogey().getStress());
            if (onTwoBogeys) {
                maxStress = Math.max(maxStress, carriage.trailingBogey().getStress());
            }
            if (index != 0) continue;
            distance = actualDistance;
            this.collideWithOtherTrains(level, carriage);
            this.backwardsDriver = null;
            if (this.graph != null) continue;
            return;
        }
        if (blocked) {
            this.speed = 0.0;
            this.navigation.cancelNavigation();
            this.runtime.tick(level);
            this.status.endOfTrack();
        } else if (maxStress > 4.0) {
            this.speed = 0.0;
            this.navigation.cancelNavigation();
            this.runtime.tick(level);
            this.derailed = true;
            this.status.highStress();
        } else if (this.speed != 0.0) {
            this.status.trackOK();
        }
        this.updateNavigationTarget(distance);
    }

    public TravellingPoint.IEdgePointListener frontSignalListener() {
        return (distance, couple) -> {
            Object patt0$temp = couple.getFirst();
            if (patt0$temp instanceof GlobalStation) {
                GlobalStation station = (GlobalStation)patt0$temp;
                if (!station.canApproachFrom((TrackNode)((Couple)couple.getSecond()).getSecond()) || this.navigation.destination != station) {
                    return false;
                }
                this.speed = 0.0;
                this.navigation.distanceToDestination = 0.0;
                this.navigation.currentPath.clear();
                this.arriveAt(this.navigation.destination);
                this.navigation.destination = null;
                return true;
            }
            Object patt1$temp = couple.getFirst();
            if (patt1$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt1$temp;
                this.occupiedObservers.add(observer.getId());
                return false;
            }
            Object patt2$temp = couple.getFirst();
            if (!(patt2$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt2$temp;
            if (this.navigation.waitingForSignal != null && this.navigation.waitingForSignal.getFirst().equals(signal.getId())) {
                this.speed = 0.0;
                this.navigation.distanceToSignal = 0.0;
                return true;
            }
            UUID groupId = signal.getGroup((TrackNode)((Couple)couple.getSecond()).getSecond());
            SignalEdgeGroup signalEdgeGroup = Create.RAILWAYS.signalEdgeGroups.get(groupId);
            if (signalEdgeGroup == null) {
                return false;
            }
            if ((this.runtime.getSchedule() == null || this.runtime.paused) && signalEdgeGroup.isOccupiedUnless(this)) {
                this.carriages.forEach(c -> c.forEachPresentEntity(cce -> cce.getControllingPlayer().ifPresent(uuid -> AllAdvancements.RED_SIGNAL.awardTo(cce.method_37908().method_18470(uuid)))));
            }
            signalEdgeGroup.reserved = signal;
            this.occupy(groupId, signal.id);
            return false;
        };
    }

    public void cancelStall() {
        this.speedBeforeStall = null;
        this.carriages.forEach(c -> {
            c.stalled = false;
            c.forEachPresentEntity(cce -> cce.getContraption().getActors().forEach(pair -> {
                MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)pair.getKey()).comp_1342());
                if (behaviour != null) {
                    behaviour.cancelStall((MovementContext)pair.getValue());
                }
            }));
        });
    }

    private boolean occupy(UUID groupId, @Nullable UUID boundaryId) {
        this.reservedSignalBlocks.remove(groupId);
        if (boundaryId != null && this.occupiedSignalBlocks.containsKey(groupId) && boundaryId.equals(this.occupiedSignalBlocks.get(groupId))) {
            return false;
        }
        return this.occupiedSignalBlocks.put(groupId, boundaryId) == null;
    }

    public TravellingPoint.IEdgePointListener backSignalListener() {
        return (distance, couple) -> {
            Object patt0$temp = couple.getFirst();
            if (patt0$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt0$temp;
                this.occupiedObservers.remove(observer.getId());
                this.cachedObserverFiltering.remove(observer.getId());
                return false;
            }
            Object patt1$temp = couple.getFirst();
            if (!(patt1$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt1$temp;
            UUID groupId = signal.getGroup((TrackNode)((Couple)couple.getSecond()).getFirst());
            this.occupiedSignalBlocks.remove(groupId);
            return false;
        };
    }

    private void updateNavigationTarget(double distance) {
        GlobalStation preferredDestination;
        if (this.navigation.destination == null) {
            return;
        }
        Pair<UUID, Boolean> blockingSignal = this.navigation.waitingForSignal;
        boolean fullRefresh = this.navigation.distanceToDestination > 100.0 && this.navigation.distanceToDestination % 100.0 > 20.0;
        boolean signalRefresh = blockingSignal != null && this.navigation.distanceToSignal % 50.0 > 5.0;
        boolean partialRefresh = this.navigation.distanceToDestination < 100.0 && this.navigation.distanceToDestination % 50.0 > 5.0;
        double toSubstract = this.navigation.destinationBehindTrain ? -distance : distance;
        boolean navigatingManually = this.runtime.paused;
        this.navigation.distanceToDestination -= toSubstract;
        if (blockingSignal != null) {
            this.navigation.distanceToSignal -= toSubstract;
            signalRefresh &= this.navigation.distanceToSignal % 50.0 < 5.0;
        }
        fullRefresh &= this.navigation.distanceToDestination % 100.0 <= 20.0;
        partialRefresh &= this.navigation.distanceToDestination % 50.0 <= 5.0;
        if (blockingSignal != null && this.navigation.ticksWaitingForSignal % 100 == 50) {
            SignalBoundary signal = this.graph.getPoint(EdgePointType.SIGNAL, blockingSignal.getFirst());
            fullRefresh |= signal != null && signal.types.get(blockingSignal.getSecond()) == SignalBlock.SignalType.CROSS_SIGNAL;
        }
        if (signalRefresh) {
            this.navigation.waitingForSignal = null;
        }
        if (!fullRefresh && !partialRefresh) {
            return;
        }
        if (!this.reservedSignalBlocks.isEmpty()) {
            return;
        }
        GlobalStation destination = this.navigation.destination;
        if (!navigatingManually && fullRefresh && (preferredDestination = this.runtime.startCurrentInstruction()) != null) {
            destination = preferredDestination;
        }
        this.navigation.startNavigation(destination, navigatingManually ? -1.0 : Double.MAX_VALUE, false);
    }

    private void tickDerailedSlowdown() {
        this.speed /= 3.0;
        if (class_3532.method_20390((double)this.speed, (double)0.0)) {
            this.speed = 0.0;
        }
    }

    private void tickPassiveSlowdown() {
        if (!this.manualTick && this.navigation.destination == null && this.speed != 0.0) {
            double acceleration = this.acceleration();
            this.speed = this.speed > 0.0 ? Math.max(this.speed - acceleration, 0.0) : Math.min(this.speed + acceleration, 0.0);
        }
        this.manualTick = false;
    }

    private void updateConductors() {
        for (Carriage carriage : this.carriages) {
            carriage.updateConductors();
        }
    }

    public boolean hasForwardConductor() {
        for (Carriage carriage : this.carriages) {
            if (!((Boolean)carriage.presentConductors.getFirst()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasBackwardConductor() {
        for (Carriage carriage : this.carriages) {
            if (!((Boolean)carriage.presentConductors.getSecond()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void collideWithOtherTrains(class_1937 level, Carriage carriage) {
        class_243 end;
        if (this.derailed) {
            return;
        }
        TravellingPoint trailingPoint = carriage.getTrailingPoint();
        TravellingPoint leadingPoint = carriage.getLeadingPoint();
        if (leadingPoint.node1 == null || trailingPoint.node1 == null) {
            return;
        }
        class_5321<class_1937> dimension = leadingPoint.node1.getLocation().dimension;
        if (!dimension.equals(trailingPoint.node1.getLocation().dimension)) {
            return;
        }
        class_243 start = (this.speed < 0.0 ? trailingPoint : leadingPoint).getPosition(this.graph);
        Pair<Train, class_243> collision = Train.findCollidingTrain(level, start, end = (this.speed < 0.0 ? leadingPoint : trailingPoint).getPosition(this.graph), this, dimension);
        if (collision == null) {
            return;
        }
        Train train = collision.getFirst();
        double combinedSpeed = Math.abs(this.speed) + Math.abs(train.speed);
        if (combinedSpeed > (double)0.2f) {
            class_243 v = collision.getSecond();
            level.method_8437(null, v.field_1352, v.field_1351, v.field_1350, (float)Math.min(3.0 * combinedSpeed, 5.0), class_1937.class_7867.field_40888);
        }
        this.crash();
        train.crash();
    }

    public static Pair<Train, class_243> findCollidingTrain(class_1937 level, class_243 start, class_243 end, Train ignore, class_5321<class_1937> dimension) {
        for (Train train : Create.RAILWAYS.sided((class_1936)level).trains.values()) {
            if (train == ignore) continue;
            class_243 diff = end.method_1020(start);
            class_243 lastPoint = null;
            for (Carriage otherCarriage : train.carriages) {
                for (boolean betweenBits : Iterate.trueAndFalse) {
                    class_243 normedDiff2;
                    class_5321<class_1937> otherDimension;
                    if (betweenBits && lastPoint == null) continue;
                    TravellingPoint otherLeading = otherCarriage.getLeadingPoint();
                    TravellingPoint otherTrailing = otherCarriage.getTrailingPoint();
                    if (otherLeading.edge == null || otherTrailing.edge == null || !(otherDimension = otherLeading.node1.getLocation().dimension).equals(otherTrailing.node1.getLocation().dimension) || !otherDimension.equals(dimension)) continue;
                    class_243 start2 = otherLeading.getPosition(train.graph);
                    class_243 end2 = otherTrailing.getPosition(train.graph);
                    if (betweenBits) {
                        end2 = start2;
                        start2 = lastPoint;
                    }
                    lastPoint = end2;
                    if ((end.field_1351 < end2.field_1351 - 3.0 || end2.field_1351 < end.field_1351 - 3.0) && (start.field_1351 < start2.field_1351 - 3.0 || start2.field_1351 < start.field_1351 - 3.0)) continue;
                    class_243 diff2 = end2.method_1020(start2);
                    class_243 normedDiff = diff.method_1029();
                    double[] intersect = VecHelper.intersect(start, start2, normedDiff, normedDiff2 = diff2.method_1029(), class_2350.class_2351.field_11052);
                    if (intersect == null) {
                        class_243 intersectSphere = VecHelper.intersectSphere(start2, normedDiff2, start, 0.125);
                        if (intersectSphere == null || !class_3532.method_20390((double)normedDiff2.method_1026(intersectSphere.method_1020(start2).method_1029()), (double)1.0)) continue;
                        intersect = new double[]{intersectSphere.method_1022(start) - 0.125, intersectSphere.method_1022(start2) - 0.125};
                    }
                    if (intersect[0] > diff.method_1033() || intersect[1] > diff2.method_1033() || intersect[0] < 0.0 || intersect[1] < 0.0) continue;
                    return Pair.of(train, start.method_1019(normedDiff.method_1021(intersect[0])));
                }
            }
        }
        return null;
    }

    public void crash() {
        this.navigation.cancelNavigation();
        if (this.derailed) {
            return;
        }
        this.speed = -class_3532.method_15350((double)this.speed, (double)-0.5, (double)0.5);
        this.derailed = true;
        this.graph = null;
        this.status.crash();
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.method_5736().forEach(entity -> {
                if (!(entity instanceof class_1657)) {
                    return;
                }
                class_1657 p = (class_1657)entity;
                Optional<UUID> controllingPlayer = e.getControllingPlayer();
                if (controllingPlayer.isPresent() && controllingPlayer.get().equals(p.method_5667())) {
                    return;
                }
                AllAdvancements.TRAIN_CRASH.awardTo(p);
            }));
        }
        if (this.backwardsDriver != null) {
            AllAdvancements.TRAIN_CRASH_BACKWARDS.awardTo(this.backwardsDriver);
        }
    }

    public boolean disassemble(class_2350 assemblyDirection, class_2338 pos) {
        if (!this.canDisassemble()) {
            return false;
        }
        int offset = 1;
        boolean backwards = this.currentlyBackwards;
        class_1937 level = null;
        for (int i = 0; i < this.carriages.size(); ++i) {
            Carriage carriage = this.carriages.get(backwards ? this.carriages.size() - i - 1 : i);
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) {
                return false;
            }
            level = entity.method_37908();
            Contraption contraption = entity.getContraption();
            if (contraption instanceof CarriageContraption) {
                CarriageContraption cc = (CarriageContraption)contraption;
                cc.returnStorageForDisassembly(carriage.storage);
            }
            entity.method_33574(class_243.method_24954((class_2382)pos.method_10079(assemblyDirection, backwards ? offset + carriage.bogeySpacing : offset).method_10087(carriage.leadingBogey().isUpsideDown() ? 2 : 0)));
            entity.disassemble();
            for (CarriageBogey bogey : carriage.bogeys) {
                class_2586 be;
                class_243 bogeyPosition;
                if (bogey == null || (bogeyPosition = bogey.getAnchorPosition()) == null || !((be = level.method_8321(class_2338.method_49638((class_2374)bogeyPosition))) instanceof AbstractBogeyBlockEntity)) continue;
                AbstractBogeyBlockEntity sbbe = (AbstractBogeyBlockEntity)be;
                sbbe.setBogeyData(bogey.bogeyData);
            }
            offset += carriage.bogeySpacing;
            if (i >= this.carriageSpacing.size()) continue;
            offset += this.carriageSpacing.get(backwards ? this.carriageSpacing.size() - i - 1 : i).intValue();
        }
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            currentStation.cancelReservation(this);
            class_2338 blockEntityPos = currentStation.getBlockEntityPos();
            class_2586 class_25862 = level.method_8321(blockEntityPos);
            if (class_25862 instanceof StationBlockEntity) {
                StationBlockEntity sbe = (StationBlockEntity)class_25862;
                sbe.lastDisassembledTrainName = this.name.method_27661();
            }
        }
        Create.RAILWAYS.removeTrain(this.id);
        AllPackets.getChannel().sendToClientsInCurrentServer((S2CPacket)new TrainPacket(this, false));
        return true;
    }

    public boolean canDisassemble() {
        for (Carriage carriage : this.carriages) {
            if (carriage.presentInMultipleDimensions()) {
                return false;
            }
            CarriageContraptionEntity entity = carriage.anyAvailableEntity();
            if (entity == null) {
                return false;
            }
            if (!class_3532.method_15347((float)entity.pitch, (float)0.0f)) {
                return false;
            }
            if (class_3532.method_15347((float)((entity.yaw % 90.0f + 360.0f) % 90.0f), (float)0.0f)) continue;
            return false;
        }
        return true;
    }

    public boolean isTravellingOn(TrackNode node) {
        MutableBoolean affected = new MutableBoolean(false);
        this.forEachTravellingPoint(tp -> {
            if (tp.node1 == node || tp.node2 == node) {
                affected.setTrue();
            }
        });
        return affected.booleanValue();
    }

    public void detachFromTracks() {
        this.migratingPoints.clear();
        this.navigation.cancelNavigation();
        this.forEachTravellingPoint(tp -> this.migratingPoints.add(new TrainMigration((TravellingPoint)tp)));
        this.graph = null;
    }

    public void forEachTravellingPoint(Consumer<TravellingPoint> callback) {
        for (Carriage c : this.carriages) {
            c.leadingBogey().points.forEach(callback::accept);
            if (!c.isOnTwoBogeys()) continue;
            c.trailingBogey().points.forEach(callback::accept);
        }
    }

    public void forEachTravellingPointBackwards(BiConsumer<TravellingPoint, Double> callback) {
        double lastWheelOffset = 0.0;
        for (int i = 0; i < this.carriages.size(); ++i) {
            int index = this.carriages.size() - i - 1;
            Carriage carriage = this.carriages.get(index);
            CarriageBogey trailingBogey = carriage.trailingBogey();
            double trailSpacing = trailingBogey.type.getWheelPointSpacing();
            callback.accept(trailingBogey.trailing(), i == 0 ? 0.0 : (double)this.carriageSpacing.get(index).intValue() - lastWheelOffset - trailSpacing / 2.0);
            callback.accept(trailingBogey.leading(), trailSpacing);
            lastWheelOffset = trailSpacing / 2.0;
            if (!carriage.isOnTwoBogeys()) continue;
            CarriageBogey leadingBogey = carriage.leadingBogey();
            double leadSpacing = carriage.leadingBogey().type.getWheelPointSpacing();
            callback.accept(leadingBogey.trailing(), (double)carriage.bogeySpacing - lastWheelOffset - leadSpacing / 2.0);
            callback.accept(trailingBogey.leading(), leadSpacing);
            lastWheelOffset = leadSpacing / 2.0;
        }
    }

    public void reattachToTracks(class_1937 level) {
        if (this.migrationCooldown > 0) {
            --this.migrationCooldown;
            return;
        }
        HashSet<Map.Entry<UUID, TrackGraph>> entrySet = new HashSet<Map.Entry<UUID, TrackGraph>>(Create.RAILWAYS.trackNetworks.entrySet());
        HashMap<UUID, List> successfulMigrations = new HashMap<UUID, List>();
        for (TrainMigration md : this.migratingPoints) {
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                TrackGraphLocation gl = md.tryMigratingTo((TrackGraph)entry.getValue());
                if (gl == null) {
                    iterator.remove();
                    continue;
                }
                successfulMigrations.computeIfAbsent((UUID)entry.getKey(), uuid -> new ArrayList()).add(gl);
            }
        }
        if (entrySet.isEmpty()) {
            this.migrationCooldown = 40;
            this.status.failedMigration();
            this.derailed = true;
            return;
        }
        Iterator<TrainMigration> iterator = entrySet.iterator();
        if (iterator.hasNext()) {
            GlobalStation currentStation;
            Map.Entry entry = (Map.Entry)((Object)iterator.next());
            this.graph = (TrackGraph)entry.getValue();
            List locations = (List)successfulMigrations.get(entry.getKey());
            this.forEachTravellingPoint(tp -> tp.migrateTo(locations));
            this.migratingPoints.clear();
            if (this.derailed) {
                this.status.successfulMigration();
            }
            this.derailed = false;
            if (this.runtime.getSchedule() != null && this.runtime.state == ScheduleRuntime.State.IN_TRANSIT) {
                this.runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
            }
            if ((currentStation = this.getCurrentStation()) != null) {
                currentStation.reserveFor(this);
            }
            this.updateSignalBlocks = true;
            this.migrationCooldown = 0;
            return;
        }
    }

    public int getTotalLength() {
        int length = 0;
        for (int i = 0; i < this.carriages.size(); ++i) {
            Carriage carriage = this.carriages.get(i);
            if (i == 0) {
                length = (int)((double)length + carriage.leadingBogey().type.getWheelPointSpacing() / 2.0);
            }
            if (i == this.carriages.size() - 1) {
                length = (int)((double)length + carriage.trailingBogey().type.getWheelPointSpacing() / 2.0);
            }
            length += carriage.bogeySpacing;
            if (i >= this.carriageSpacing.size()) continue;
            length += this.carriageSpacing.get(i).intValue();
        }
        return length;
    }

    public void leaveStation() {
        GlobalStation currentStation = this.getCurrentStation();
        if (currentStation != null) {
            currentStation.trainDeparted(this);
        }
        this.currentStation = null;
    }

    public void arriveAt(GlobalStation station) {
        this.setCurrentStation(station);
        this.reservedSignalBlocks.clear();
        this.runtime.destinationReached();
    }

    public void setCurrentStation(GlobalStation station) {
        this.currentStation = station.id;
    }

    public GlobalStation getCurrentStation() {
        if (this.currentStation == null) {
            return null;
        }
        if (this.graph == null) {
            return null;
        }
        return this.graph.getPoint(EdgePointType.STATION, this.currentStation);
    }

    @Nullable
    public class_1309 getOwner(class_1937 level) {
        try {
            UUID uuid = this.owner;
            return uuid == null ? null : level.method_8503().method_3760().method_14602(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void approachTargetSpeed(float accelerationMod) {
        double actualTarget = this.targetSpeed;
        if (class_3532.method_20390((double)actualTarget, (double)this.speed)) {
            return;
        }
        if (this.manualTick) {
            this.leaveStation();
        }
        double acceleration = this.acceleration();
        if (this.speed < actualTarget) {
            this.speed = Math.min(this.speed + acceleration * (double)accelerationMod, actualTarget);
        } else if (this.speed > actualTarget) {
            this.speed = Math.max(this.speed - acceleration * (double)accelerationMod, actualTarget);
        }
    }

    public void collectInitiallyOccupiedSignalBlocks() {
        TravellingPoint trailingPoint = this.carriages.get(this.carriages.size() - 1).getTrailingPoint();
        TrackNode node1 = trailingPoint.node1;
        TrackNode node2 = trailingPoint.node2;
        TrackEdge edge = trailingPoint.edge;
        double position = trailingPoint.position;
        EdgeData signalData = edge.getEdgeData();
        this.occupiedSignalBlocks.clear();
        this.reservedSignalBlocks.clear();
        this.occupiedObservers.clear();
        this.cachedObserverFiltering.clear();
        TravellingPoint signalScout = new TravellingPoint(node1, node2, edge, position, false);
        Map<UUID, SignalEdgeGroup> allGroups = Create.RAILWAYS.signalEdgeGroups;
        MutableObject prevGroup = new MutableObject(null);
        if (signalData.hasSignalBoundaries()) {
            SignalBoundary nextBoundary = signalData.next(EdgePointType.SIGNAL, position);
            if (nextBoundary == null) {
                UUID group;
                double d2 = 0.0;
                SignalBoundary prev = null;
                SignalBoundary current = signalData.next(EdgePointType.SIGNAL, 0.0);
                while (current != null) {
                    prev = current;
                    d2 = current.getLocationOn(edge);
                    current = signalData.next(EdgePointType.SIGNAL, d2);
                }
                if (prev != null && Create.RAILWAYS.signalEdgeGroups.containsKey(group = prev.getGroup(node2))) {
                    this.occupy(group, null);
                    prevGroup.setValue((Object)group);
                }
            } else {
                UUID group = nextBoundary.getGroup(node1);
                if (Create.RAILWAYS.signalEdgeGroups.containsKey(group)) {
                    this.occupy(group, null);
                    prevGroup.setValue((Object)group);
                }
            }
        } else {
            UUID groupId = signalData.getEffectiveEdgeGroupId(this.graph);
            if (allGroups.containsKey(groupId)) {
                this.occupy(groupId, null);
                prevGroup.setValue((Object)groupId);
            }
        }
        this.forEachTravellingPointBackwards((tp, d) -> signalScout.travel(this.graph, (double)d, signalScout.follow((TravellingPoint)tp), (distance, couple) -> {
            Object patt0$temp = couple.getFirst();
            if (patt0$temp instanceof TrackObserver) {
                TrackObserver observer = (TrackObserver)patt0$temp;
                this.occupiedObservers.add(observer.getId());
                return false;
            }
            Object patt1$temp = couple.getFirst();
            if (!(patt1$temp instanceof SignalBoundary)) {
                return false;
            }
            SignalBoundary signal = (SignalBoundary)patt1$temp;
            ((Couple)couple.getSecond()).map(signal::getGroup).forEach(id -> {
                if (!Create.RAILWAYS.signalEdgeGroups.containsKey(id)) {
                    return;
                }
                if (id.equals(prevGroup.getValue())) {
                    return;
                }
                this.occupy((UUID)id, null);
                prevGroup.setValue(id);
            });
            return false;
        }, signalScout.ignoreTurns()));
    }

    public boolean shouldCarriageSyncThisTick(long gameTicks, int updateInterval) {
        return (gameTicks + (long)this.tickOffset) % (long)updateInterval == 0L;
    }

    public Couple<Couple<TrackNode>> getEndpointEdges() {
        return Couple.create(this.carriages.get(0).getLeadingPoint(), this.carriages.get(this.carriages.size() - 1).getTrailingPoint()).map(tp -> Couple.create(tp.node1, tp.node2));
    }

    public int getNavigationPenalty() {
        if (this.manualTick) {
            return 200;
        }
        if (this.runtime.getSchedule() == null || this.runtime.paused) {
            return 700;
        }
        if (this.navigation.waitingForSignal != null && this.navigation.ticksWaitingForSignal > 0) {
            return 50 + Math.min(this.navigation.ticksWaitingForSignal / 20, 1000);
        }
        if (this.navigation.destination != null && this.navigation.distanceToDestination < 50.0 || this.navigation.distanceToSignal < 20.0) {
            return 50;
        }
        return 25;
    }

    public void burnFuel() {
        if (this.fuelTicks > 0) {
            --this.fuelTicks;
            return;
        }
        boolean iterateFromBack = this.speed < 0.0;
        int carriageCount = this.carriages.size();
        for (int index = 0; index < carriageCount; ++index) {
            int i = iterateFromBack ? carriageCount - 1 - index : index;
            Carriage carriage = this.carriages.get(i);
            Contraption.ContraptionInvWrapper fuelItems = carriage.storage.getFuelItems();
            if (fuelItems == null) continue;
            try (Transaction t = TransferUtil.getTransaction();){
                for (StorageView view : fuelItems.nonEmptyViews()) {
                    ItemVariant held = (ItemVariant)view.getResource();
                    Integer burnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)held.getItem());
                    if (burnTime == null || burnTime <= 0 || view.extract((Object)held, 1L, (TransactionContext)t) != 1L) continue;
                    this.fuelTicks += burnTime.intValue();
                    class_1799 containerItem = held.toStack().getRecipeRemainder();
                    if (!containerItem.method_7960()) {
                        TransferUtil.insertItem((Storage)fuelItems, (class_1799)containerItem);
                    }
                    t.commit();
                    return;
                }
                continue;
            }
        }
    }

    public float maxSpeed() {
        return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainTopSpeed.getF() : AllConfigs.server().trains.trainTopSpeed.getF()) / 20.0f;
    }

    public float maxTurnSpeed() {
        return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainTurningTopSpeed.getF() : AllConfigs.server().trains.trainTurningTopSpeed.getF()) / 20.0f;
    }

    public float acceleration() {
        return (this.fuelTicks > 0 ? AllConfigs.server().trains.poweredTrainAcceleration.getF() : AllConfigs.server().trains.trainAcceleration.getF()) / 400.0f;
    }

    public class_2487 write(DimensionPalette dimensions) {
        class_2487 tag = new class_2487();
        tag.method_25927("Id", this.id);
        if (this.owner != null) {
            tag.method_25927("Owner", this.owner);
        }
        if (this.graph != null) {
            tag.method_25927("Graph", this.graph.id);
        }
        tag.method_10566("Carriages", (class_2520)NBTHelper.writeCompoundList(this.carriages, c -> c.write(dimensions)));
        tag.method_10572("CarriageSpacing", this.carriageSpacing);
        tag.method_10556("DoubleEnded", this.doubleEnded);
        tag.method_10549("Speed", this.speed);
        tag.method_10549("Throttle", this.throttle);
        if (this.speedBeforeStall != null) {
            tag.method_10549("SpeedBeforeStall", this.speedBeforeStall.doubleValue());
        }
        tag.method_10569("Fuel", this.fuelTicks);
        tag.method_10549("TargetSpeed", this.targetSpeed);
        tag.method_10582("IconType", this.icon.id.toString());
        tag.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.name));
        if (this.currentStation != null) {
            tag.method_25927("Station", this.currentStation);
        }
        tag.method_10556("Backwards", this.currentlyBackwards);
        tag.method_10556("Derailed", this.derailed);
        tag.method_10556("UpdateSignals", this.updateSignalBlocks);
        tag.method_10566("SignalBlocks", (class_2520)NBTHelper.writeCompoundList(this.occupiedSignalBlocks.entrySet(), e -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_25927("Id", (UUID)e.getKey());
            if (e.getValue() != null) {
                compoundTag.method_25927("Boundary", (UUID)e.getValue());
            }
            return compoundTag;
        }));
        tag.method_10566("ReservedSignalBlocks", (class_2520)NBTHelper.writeCompoundList(this.reservedSignalBlocks, uid -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_25927("Id", uid);
            return compoundTag;
        }));
        tag.method_10566("OccupiedObservers", (class_2520)NBTHelper.writeCompoundList(this.occupiedObservers, uid -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_25927("Id", uid);
            return compoundTag;
        }));
        tag.method_10566("MigratingPoints", (class_2520)NBTHelper.writeCompoundList(this.migratingPoints, tm -> tm.write(dimensions)));
        tag.method_10566("Runtime", (class_2520)this.runtime.write());
        tag.method_10566("Navigation", (class_2520)this.navigation.write(dimensions));
        return tag;
    }

    public static Train read(class_2487 tag, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions) {
        UUID id = tag.method_25926("Id");
        UUID owner = tag.method_10545("Owner") ? tag.method_25926("Owner") : null;
        UUID graphId = tag.method_10545("Graph") ? tag.method_25926("Graph") : null;
        TrackGraph graph = graphId == null ? null : trackNetworks.get(graphId);
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        NBTHelper.iterateCompoundList(tag.method_10554("Carriages", 10), c -> carriages.add(Carriage.read(c, graph, dimensions)));
        ArrayList<Integer> carriageSpacing = new ArrayList<Integer>();
        for (int i : tag.method_10561("CarriageSpacing")) {
            carriageSpacing.add(i);
        }
        boolean doubleEnded = tag.method_10577("DoubleEnded");
        Train train = new Train(id, owner, graph, carriages, carriageSpacing, doubleEnded);
        train.speed = tag.method_10574("Speed");
        train.throttle = tag.method_10574("Throttle");
        if (tag.method_10545("SpeedBeforeStall")) {
            train.speedBeforeStall = tag.method_10574("SpeedBeforeStall");
        }
        train.targetSpeed = tag.method_10574("TargetSpeed");
        train.icon = TrainIconType.byId(new class_2960(tag.method_10558("IconType")));
        train.name = class_2561.class_2562.method_10877((String)tag.method_10558("Name"));
        train.currentStation = tag.method_10545("Station") ? tag.method_25926("Station") : null;
        train.currentlyBackwards = tag.method_10577("Backwards");
        train.derailed = tag.method_10577("Derailed");
        train.updateSignalBlocks = tag.method_10577("UpdateSignals");
        train.fuelTicks = tag.method_10550("Fuel");
        NBTHelper.iterateCompoundList(tag.method_10554("SignalBlocks", 10), c -> train.occupiedSignalBlocks.put(c.method_25926("Id"), c.method_10545("Boundary") ? c.method_25926("Boundary") : null));
        NBTHelper.iterateCompoundList(tag.method_10554("ReservedSignalBlocks", 10), c -> train.reservedSignalBlocks.add(c.method_25926("Id")));
        NBTHelper.iterateCompoundList(tag.method_10554("OccupiedObservers", 10), c -> train.occupiedObservers.add(c.method_25926("Id")));
        NBTHelper.iterateCompoundList(tag.method_10554("MigratingPoints", 10), c -> train.migratingPoints.add(TrainMigration.read(c, dimensions)));
        train.runtime.read(tag.method_10562("Runtime"));
        train.navigation.read(tag.method_10562("Navigation"), graph, dimensions);
        if (train.getCurrentStation() != null) {
            train.getCurrentStation().reserveFor(train);
        }
        return train;
    }

    public int countPlayerPassengers() {
        AtomicInteger count = new AtomicInteger();
        for (Carriage carriage : this.carriages) {
            carriage.forEachPresentEntity(e -> e.method_5736().forEach(p -> {
                if (p instanceof class_1657) {
                    count.incrementAndGet();
                }
            }));
        }
        return count.intValue();
    }

    public void determineHonk(class_1937 level) {
        if (this.lowHonk != null) {
            return;
        }
        for (int index = 0; index < this.carriages.size(); ++index) {
            Contraption contraption;
            Carriage carriage = this.carriages.get(index);
            Carriage.DimensionalCarriageEntity dimensional = carriage.getDimensionalIfPresent((class_5321<class_1937>)level.method_27983());
            if (dimensional == null) {
                return;
            }
            CarriageContraptionEntity entity = (CarriageContraptionEntity)((Object)dimensional.entity.get());
            if (entity == null || !((contraption = entity.getContraption()) instanceof CarriageContraption)) break;
            CarriageContraption otherCC = (CarriageContraption)contraption;
            Pair<Boolean, Integer> first = otherCC.soundQueue.getFirstWhistle(entity);
            if (first == null) continue;
            this.lowHonk = first.getFirst();
            this.honkPitch = first.getSecond();
        }
    }

    public float distanceToLocationSqr(class_1937 level, class_243 location) {
        float distance = Float.MAX_VALUE;
        for (Carriage carriage : this.carriages) {
            Carriage.DimensionalCarriageEntity dce = carriage.getDimensionalIfPresent((class_5321<class_1937>)level.method_27983());
            if (dce == null || dce.positionAnchor == null) continue;
            distance = Math.min(distance, (float)dce.positionAnchor.method_1025(location));
        }
        return distance;
    }

    public static class Penalties {
        static final int STATION = 200;
        static final int STATION_WITH_TRAIN = 300;
        static final int MANUAL_TRAIN = 200;
        static final int IDLE_TRAIN = 700;
        static final int ARRIVING_TRAIN = 50;
        static final int WAITING_TRAIN = 50;
        static final int ANY_TRAIN = 25;
        static final int RED_SIGNAL = 25;
        static final int REDSTONE_RED_SIGNAL = 400;
    }
}

