/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.mixin.client;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionCollider;
import com.simibubi.create.content.contraptions.ContraptionHandler;
import io.github.fabricators_of_create.porting_lib.block.CustomRunningEffectsBlock;
import java.lang.ref.Reference;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import net.minecraft.class_4048;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.util.TriConsumer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityContraptionInteractionMixin {
    @Shadow
    public class_1937 field_6002;
    @Shadow
    private class_243 field_22467;
    @Shadow
    private float field_6003;
    @Shadow
    @Final
    protected class_5819 field_5974;
    @Shadow
    private class_4048 field_18065;

    @Shadow
    protected abstract float method_5867();

    @Shadow
    protected abstract void method_5712(class_2338 var1, class_2680 var2);

    @Unique
    private Stream<AbstractContraptionEntity> create$getIntersectionContraptionsStream() {
        return ContraptionHandler.loadedContraptions.get((class_1936)this.field_6002).values().stream().map(Reference::get).filter(cEntity -> cEntity != null && cEntity.collidingEntities.containsKey((class_1297)this));
    }

    @Unique
    private Set<AbstractContraptionEntity> create$getIntersectingContraptions() {
        Set<AbstractContraptionEntity> contraptions = this.create$getIntersectionContraptionsStream().collect(Collectors.toSet());
        contraptions.addAll(this.field_6002.method_18467(AbstractContraptionEntity.class, ((class_1297)this).method_5829().method_1014(1.0)));
        return contraptions;
    }

    @Unique
    private void forCollision(class_243 worldPos, TriConsumer<Contraption, class_2680, class_2338> action) {
        this.create$getIntersectingContraptions().forEach(cEntity -> {
            class_243 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            class_2338 blockPos = class_2338.method_49638((class_2374)localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
            if (info != null) {
                class_2680 blockstate = info.comp_1342();
                action.accept((Object)contraption, (Object)blockstate, (Object)blockPos);
            }
        });
    }

    @Inject(method={"move"}, at={@At(value="JUMP", opcode=154, ordinal=7)})
    private void create$contraptionStepSounds(class_1313 mover, class_243 movement, CallbackInfo ci) {
        class_243 worldPos = this.field_22467.method_1031(0.0, -0.2, 0.0);
        MutableBoolean stepped = new MutableBoolean(false);
        this.forCollision(worldPos, (TriConsumer<Contraption, class_2680, class_2338>)((TriConsumer)(contraption, state, pos) -> {
            this.method_5712((class_2338)pos, (class_2680)state);
            stepped.setTrue();
        }));
        if (stepped.booleanValue()) {
            this.field_6003 = this.method_5867();
        }
    }

    @Inject(method={"move"}, at={@At(value="TAIL")})
    private void create$onMove(class_1313 mover, class_243 movement, CallbackInfo ci) {
        if (!this.field_6002.field_9236) {
            return;
        }
        class_1297 self = (class_1297)this;
        if (self.method_24828()) {
            return;
        }
        if (self.method_5765()) {
            return;
        }
        class_243 worldPos = this.field_22467.method_1031(0.0, -0.2, 0.0);
        boolean onAtLeastOneContraption = this.create$getIntersectionContraptionsStream().anyMatch(cEntity -> {
            class_243 localPos = ContraptionCollider.worldToLocalPos(worldPos, cEntity);
            class_2338 blockPos = class_2338.method_49638((class_2374)localPos);
            Contraption contraption = cEntity.getContraption();
            class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
            if (info == null) {
                return false;
            }
            cEntity.registerColliding(self);
            return true;
        });
        if (!onAtLeastOneContraption) {
            return;
        }
        self.method_24830(true);
        self.getCustomData().method_10556("ContraptionGrounded", true);
    }

    @Inject(method={"spawnSprintParticle"}, at={@At(value="TAIL")})
    private void create$onSpawnSprintParticle(CallbackInfo ci) {
        class_1297 self = (class_1297)this;
        class_243 worldPos = this.field_22467.method_1031(0.0, -0.2, 0.0);
        class_2338 particlePos = class_2338.method_49638((class_2374)worldPos);
        this.forCollision(worldPos, (TriConsumer<Contraption, class_2680, class_2338>)((TriConsumer)(contraption, state, pos) -> {
            CustomRunningEffectsBlock custom;
            boolean particles = state.method_26217() != class_2464.field_11455;
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof CustomRunningEffectsBlock && (custom = (CustomRunningEffectsBlock)patt0$temp).addRunningEffects(state, self.method_37908(), pos, self)) {
                particles = false;
            }
            if (particles) {
                class_243 speed = self.method_18798();
                this.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, state).setSourcePos(particlePos), self.method_23317() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.field_18065.field_18067, self.method_23318() + 0.1, self.method_23321() + ((double)this.field_5974.method_43057() - 0.5) * (double)this.field_18065.field_18068, speed.field_1352 * -4.0, 1.5, speed.field_1350 * -4.0);
            }
        }));
    }
}

