/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.serialization.Codec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricPonderProcessing {
    public static final Codec<Processor> PROCESSOR_CODEC = class_2960.field_25139.fieldOf("structureId").xmap(Processor::new, processor -> processor.structureId).codec();
    public static final class_3828<Processor> PROCESSOR_TYPE = (class_3828)class_2378.method_10230((class_2378)class_7923.field_41161, (class_2960)Create.asResource("fabric_ponder_processor"), () -> PROCESSOR_CODEC);
    public static final ProcessingPredicate ALWAYS = (id, process) -> true;
    private static final Map<String, ProcessingPredicate> predicates = new HashMap<String, ProcessingPredicate>();

    public static ProcessingPredicate register(String modId, ProcessingPredicate predicate) {
        ProcessingPredicate existing = predicates.get(modId);
        if (existing != null) {
            throw new IllegalStateException("Tried to register ProcessingPredicate [%s] for mod '%s', while one already exists: [%s]".formatted(predicate, modId, existing));
        }
        predicates.put(modId, predicate);
        return predicate;
    }

    public static class_3492 makePlaceSettings(class_2960 structureId) {
        return new class_3492().method_16184((class_3491)new Processor(structureId));
    }

    @ApiStatus.Internal
    public static void init() {
        FabricPonderProcessing.register("create", ALWAYS);
    }

    @FunctionalInterface
    public static interface ProcessingPredicate {
        public boolean shouldApplyProcess(class_2960 var1, Process var2);
    }

    public static class Processor
    extends class_3491 {
        public final class_2960 structureId;

        public Processor(class_2960 structureId) {
            this.structureId = structureId;
        }

        @Nullable
        public class_3499.class_3501 method_15110(@NotNull class_4538 level, @NotNull class_2338 pos, @NotNull class_2338 pivot, @NotNull class_3499.class_3501 blockInfo, @NotNull class_3499.class_3501 relativeBlockInfo, @NotNull class_3492 settings) {
            ProcessingPredicate predicate = predicates.get(this.structureId.method_12836());
            if (predicate == null) {
                return relativeBlockInfo;
            }
            class_2487 nbt = relativeBlockInfo.comp_1343();
            if (nbt != null && AllBlocks.FLUID_TANK.has(relativeBlockInfo.comp_1342()) && nbt.method_10573("TankContent", 10) && predicate.shouldApplyProcess(this.structureId, Process.FLUID_TANK_AMOUNTS)) {
                FluidStack content = FluidStack.loadFluidStackFromNBT((class_2487)nbt.method_10562("TankContent"));
                long amount = content.getAmount();
                float buckets = (float)amount / 1000.0f;
                long fixedAmount = (long)(buckets * 81000.0f);
                content.setAmount(fixedAmount);
                class_2487 newNbt = nbt.method_10553();
                newNbt.method_10566("TankContent", (class_2520)content.writeToNBT(new class_2487()));
                return new class_3499.class_3501(relativeBlockInfo.comp_1341(), relativeBlockInfo.comp_1342(), newNbt);
            }
            return relativeBlockInfo;
        }

        @NotNull
        protected class_3828<?> method_16772() {
            return PROCESSOR_TYPE;
        }
    }

    public static enum Process {
        FLUID_TANK_AMOUNTS;

    }
}

