/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.infrastructure.ponder.AllPonderTags;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import com.simibubi.create.infrastructure.ponder.SharedText;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_2960;

public class PonderLocalization {
    static final Map<class_2960, String> SHARED = new HashMap<class_2960, String>();
    static final Map<class_2960, Couple<String>> TAG = new HashMap<class_2960, Couple<String>>();
    static final Map<class_2960, String> CHAPTER = new HashMap<class_2960, String>();
    static final Map<class_2960, Map<String, String>> SPECIFIC = new HashMap<class_2960, Map<String, String>>();
    public static final String LANG_PREFIX = "ponder.";

    public static void registerShared(class_2960 key, String enUS) {
        SHARED.put(key, enUS);
    }

    public static void registerTag(class_2960 key, String enUS, String description) {
        TAG.put(key, Couple.create(enUS, description));
    }

    public static void registerChapter(class_2960 key, String enUS) {
        CHAPTER.put(key, enUS);
    }

    public static void registerSpecific(class_2960 sceneId, String key, String enUS) {
        SPECIFIC.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    public static String getShared(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return SHARED.containsKey(key) ? SHARED.get(key) : "unregistered shared entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    public static String getTag(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getFirst() : "unregistered tag entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    public static String getTagDescription(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getSecond() : "unregistered tag entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    public static String getChapter(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return CHAPTER.containsKey(key) ? CHAPTER.get(key) : "unregistered chapter entry: " + String.valueOf(key);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForChapter(key), (Object[])new Object[0]);
    }

    public static String getSpecific(class_2960 sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            return SPECIFIC.get(sceneId).get(k);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    public static void record(String namespace, JsonObject object) {
        SHARED.forEach((k, v) -> {
            if (k.method_12836().equals(namespace)) {
                object.addProperty(PonderLocalization.langKeyForShared(k), v);
            }
        });
        TAG.forEach((k, v) -> {
            if (k.method_12836().equals(namespace)) {
                object.addProperty(PonderLocalization.langKeyForTag(k), (String)v.getFirst());
                object.addProperty(PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
            }
        });
        CHAPTER.forEach((k, v) -> {
            if (k.method_12836().equals(namespace)) {
                object.addProperty(PonderLocalization.langKeyForChapter(k), v);
            }
        });
        SPECIFIC.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace)).sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> object.addProperty(PonderLocalization.langKeyForSpecific((class_2960)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
    }

    private static void recordGeneral(JsonObject object) {
        PonderLocalization.addGeneral(object, "ponder.hold_to_ponder", "Hold [%1$s] to Ponder");
        PonderLocalization.addGeneral(object, "ponder.subject", "Subject of this scene");
        PonderLocalization.addGeneral(object, "ponder.pondering", "Pondering about...");
        PonderLocalization.addGeneral(object, "ponder.identify_mode", "Identify mode active.\nUnpause with [%1$s]");
        PonderLocalization.addGeneral(object, "ponder.associated", "Associated Entries");
        PonderLocalization.addGeneral(object, "ponder.close", "Close");
        PonderLocalization.addGeneral(object, "ponder.identify", "Identify");
        PonderLocalization.addGeneral(object, "ponder.next", "Next Scene");
        PonderLocalization.addGeneral(object, "ponder.next_up", "Up Next:");
        PonderLocalization.addGeneral(object, "ponder.previous", "Previous Scene");
        PonderLocalization.addGeneral(object, "ponder.replay", "Replay");
        PonderLocalization.addGeneral(object, "ponder.think_back", "Think Back");
        PonderLocalization.addGeneral(object, "ponder.slow_text", "Comfy Reading");
        PonderLocalization.addGeneral(object, "ponder.exit", "Exit");
        PonderLocalization.addGeneral(object, "ponder.welcome", "Welcome to Ponder");
        PonderLocalization.addGeneral(object, "ponder.categories", "Available Categories in Create");
        PonderLocalization.addGeneral(object, "ponder.index_description", "Click one of the icons to learn about its associated Items and Blocks");
        PonderLocalization.addGeneral(object, "ponder.index_title", "Ponder Index");
    }

    private static void addGeneral(JsonObject json, String key, String enUS) {
        json.addProperty("create." + key, enUS);
    }

    public static void generateSceneLang() {
        PonderRegistry.ALL.forEach((id, list) -> {
            for (int i = 0; i < list.size(); ++i) {
                PonderRegistry.compileScene(i, (PonderStoryBoardEntry)list.get(i), null);
            }
        });
    }

    public static JsonObject provideLangEntries() {
        SharedText.gatherText();
        AllPonderTags.register();
        PonderIndex.register();
        PonderLocalization.generateSceneLang();
        JsonObject object = new JsonObject();
        PonderLocalization.recordGeneral(object);
        PonderLocalization.record("create", object);
        return object;
    }

    public static void provideRegistrateLang(AbstractRegistrate<?> registrate) {
        PonderLocalization.generateSceneLang();
        JsonObject object = new JsonObject();
        PonderLocalization.record(registrate.getModid(), object);
        for (Map.Entry entry : object.entrySet()) {
            registrate.addRawLang((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
    }

    protected static String langKeyForShared(class_2960 k) {
        return k.method_12836() + ".ponder.shared." + k.method_12832();
    }

    protected static String langKeyForTag(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832();
    }

    protected static String langKeyForTagDescription(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832() + ".description";
    }

    protected static String langKeyForChapter(class_2960 k) {
        return k.method_12836() + ".ponder.chapter." + k.method_12832();
    }

    protected static String langKeyForSpecific(class_2960 sceneId, String k) {
        return sceneId.method_12836() + ".ponder." + sceneId.method_12832() + "." + k;
    }
}

