/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.qendolin.betterclouds.ConfigGUI;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.renderdoc.CaptureManager;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.renderdoc.RenderDocLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class Commands {
    static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:profile").then(ClientCommandManager.argument((String)"interval", (ArgumentType)IntegerArgumentType.integer((int)30)).executes(context -> {
            int interval = IntegerArgumentType.getInteger((CommandContext)context, (String)"interval");
            Main.debugChatMessage("profiling.enabled", interval);
            Debug.profileInterval = interval;
            return 1;
        }))).then(ClientCommandManager.literal((String)"stop").executes(context -> {
            Main.debugChatMessage("profiling.disabled", new Object[0]);
            Debug.profileInterval = 0;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:frustum").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getClient().field_1769.method_35775();
            return 1;
        }))).then(ClientCommandManager.literal((String)"release").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getClient().field_1769.method_35776();
            return 1;
        }))).then(ClientCommandManager.literal((String)"debugCulling").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            Debug.frustumCulling = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:generator").then(ClientCommandManager.literal((String)"pause").executes(context -> {
            Debug.generatorPause = true;
            Main.debugChatMessage("generatorPaused", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"resume").executes(context -> {
            Debug.generatorPause = false;
            Main.debugChatMessage("generatorResumed", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"update").executes(context -> {
            Debug.generatorForceUpdate = true;
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:animation").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pause").executes(context -> {
            Debug.animationPause = 0;
            Main.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })).then(ClientCommandManager.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            Debug.animationPause = IntegerArgumentType.getInteger((CommandContext)context, (String)"ticks");
            Main.debugChatMessage("animationPaused", new Object[0]);
            return 1;
        })))).then(ClientCommandManager.literal((String)"resume").executes(context -> {
            Debug.animationPause = -1;
            Main.debugChatMessage("animationResumed", new Object[0]);
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:config").then(ClientCommandManager.literal((String)"open").executes(context -> {
            class_310 client = ((FabricClientCommandSource)context.getSource()).getClient();
            client.method_18858(() -> client.method_1507((class_437)ConfigGUI.create(null)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"reload").executes(context -> {
            Main.debugChatMessage("reloadingConfig", new Object[0]);
            Main.getConfigInstance().load();
            Main.debugChatMessage("configReloaded", new Object[0]);
            return 1;
        }))).then(ClientCommandManager.literal((String)"gpuIncompatibleMessage").then(ClientCommandManager.argument((String)"enable", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enable = BoolArgumentType.getBool((CommandContext)context, (String)"enable");
            if (Main.getConfig().gpuIncompatibleMessageEnabled == enable) {
                return 1;
            }
            Main.getConfig().gpuIncompatibleMessageEnabled = enable;
            Main.getConfigInstance().save();
            Main.debugChatMessage("updatedPreferences", new Object[0]);
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"betterclouds:debug").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"renderdoc").then(ClientCommandManager.literal((String)"capture").executes(context -> {
            if (RenderDoc.isAvailable()) {
                Main.debugChatMessage("renderdoc.capture.trigger", new Object[0]);
                CaptureManager.capture(result -> {
                    if (result == null) {
                        Main.debugChatMessage("renderdoc.capture.failure", new Object[0]);
                    } else {
                        Path path = Path.of(result.path(), new String[0]);
                        Main.debugChatMessage("renderdoc.capture.success", class_2561.method_43470((String)path.toAbsolutePath().normalize().toString()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, path.getParent().toString()))));
                    }
                });
                return 1;
            }
            if (RenderDocLoader.isAvailable()) {
                Main.debugChatMessage((class_2561)class_2561.method_43469((String)Main.debugChatMessageKey("renderdoc.prompt.load"), (Object[])new Object[]{class_2561.method_43471((String)Main.debugChatMessageKey("renderdoc.prompt.load.action")).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/betterclouds:debug renderdoc load")))}));
                return 0;
            }
            Main.debugChatMessage((class_2561)class_2561.method_43469((String)Main.debugChatMessageKey("renderdoc.prompt.install"), (Object[])new Object[]{class_2561.method_43471((String)Main.debugChatMessageKey("renderdoc.prompt.install.action")).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/betterclouds:debug renderdoc install")))}));
            return 0;
        }))).then(ClientCommandManager.literal((String)"install").executes(context -> {
            CompletableFuture.runAsync(() -> {
                if (!RenderDoc.isAvailable() && !RenderDocLoader.isAvailable()) {
                    Main.debugChatMessage("renderdoc.downloading", new Object[0]);
                    try {
                        RenderDocLoader.install();
                    }
                    catch (Exception e) {
                        Main.debugChatMessage("generic.error", e.toString());
                    }
                }
                Path path = RenderDocLoader.libPath();
                Main.debugChatMessage("renderdoc.installed", class_2561.method_43470((String)path.toAbsolutePath().normalize().toString()).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, path.getParent().toString()))));
            });
            return 1;
        }))).then(ClientCommandManager.literal((String)"uninstall").executes(context -> {
            try {
                RenderDocLoader.uninstall();
            }
            catch (Exception e) {
                Main.debugChatMessage("generic.error", e.toString());
                return 0;
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"load").executes(context -> {
            if (!RenderDocLoader.isAvailable()) {
                Main.debugChatMessage((class_2561)class_2561.method_43469((String)Main.debugChatMessageKey("renderdoc.prompt.install"), (Object[])new Object[]{class_2561.method_43471((String)Main.debugChatMessageKey("renderdoc.prompt.install.action")).method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11750, "/betterclouds:debug renderdoc install")))}));
                return 0;
            }
            if (RenderDoc.isAvailable()) {
                Main.debugChatMessage("renderdoc.load.ready", RenderDoc.getAPIVersion());
                return 1;
            }
            try {
                long expires = System.currentTimeMillis() + 43200000L;
                CaptureManager.writeLaunchConfig(new CaptureManager.LaunchConfig(true, true, expires));
            }
            catch (IOException e) {
                Main.debugChatMessage("generic.error", e.toString());
                return 0;
            }
            Main.debugChatMessage("renderdoc.load.queued", new Object[0]);
            return 1;
        }))));
    }
}

