#version 120
#extension GL_EXT_gpu_shader4 : enable
#define TONEMAP_ACES
#define VANILLA_LIKE_FOG


varying vec4 fogColor;
varying vec3 wsunVec;
varying vec2 texcoord;
varying vec3 exposure;

uniform sampler2D depthtex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D gaux1;
uniform sampler2D shadow;
uniform sampler2D noisetex;
uniform int isEyeInWater;
uniform float rainStrength;
uniform ivec2 eyeBrightness;
uniform vec2 texelSize;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform vec3 sunVec;
uniform float skyIntensity;
uniform float skyIntensityNight;
uniform vec4 lightCol;
#include "lib/color_transforms.glsl"
#include "lib/sky_gradient.glsl"

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

vec3 toScreenSpace(vec3 p) {
	vec4 iProjDiag = vec4(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].zw);
    vec3 p3 = p * 2. - 1.;
    vec4 fragposition = iProjDiag * p3.xyzz + gbufferProjectionInverse[3];
    return fragposition.xyz / fragposition.w;
}
float interleaved_gradientNoise(){
	return fract(52.9829189*fract(0.06711056/MC_RENDER_QUALITY*gl_FragCoord.x  + 0.00583715/MC_RENDER_QUALITY *gl_FragCoord.y));
}
vec3 int8Dither(vec3 color){
	float dither = interleaved_gradientNoise();
	return color + dither*exp2(-8.0);
}


void main() {
/* DRAWBUFFERS:0 */
	vec3 color = texture2D(colortex1,texcoord).rgb;


	float z = texture2D(depthtex0,texcoord).x;
	if (isEyeInWater == 0){
		if (z < 1.0){
			vec3 fragpos = toScreenSpace(vec3(texcoord,z));
			float dist = length(fragpos);
			float atten = eyeBrightness.y/255.*16/(15.5-0.006)+0.006;

			vec3 np3 = mat3(gbufferModelViewInverse) * (fragpos/(dist));
			vec3 skyColor = getSkyColorLut(np3,mat3(gbufferModelViewInverse)*sunVec,np3.y,gaux1)*10.;
			#ifndef VANILLA_LIKE_FOG
				float fogFactorAbs = exp(-dist*fogColor.a);
				float fogFactorScat = exp(-dist*fogColor.a);
				vec3 col0 = normalize(skyColor)*(skyIntensity*mix(vec3(1.),vec3(0.8,0.9,1.)*0.1,rainStrength)+skyIntensityNight*0.01)*20.;
				vec3 fogColor = mix(col0,skyColor,clamp(dist/512.,0.,1.));
			#else
				float fogFactorAbs = 1.0 - clamp((dist - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
				float fogFactorScat = fogFactorAbs;
				vec3 fogColor = skyColor;
			#endif



				color.rgb = skyColor*(1.0-fogFactorScat)*atten+color*fogFactorAbs;


			}
	}
	else {
		vec3 fragpos = toScreenSpace(vec3(texcoord,z));
		float dist = length(fragpos);
		float fogFactorAbs = exp(-dist*fogColor.a);
		float fogFactorScat = exp(-dist*fogColor.a);
		color.rgb = fogColor.rgb*(1.0-fogFactorScat)+color*fogFactorAbs;
	}
	color = texture2D(colortex2,texcoord).rgb + color*(1.0-texture2D(colortex2,texcoord).a);
			//tonemap
			#ifndef TONEMAP_ACES
				gl_FragData[0].rgb = int8Dither(Uncharted2Tonemap(exposure*color)/Uncharted2Tonemap(vec3(11.2)));
			#endif
			#ifdef TONEMAP_ACES
				gl_FragData[0].rgb = int8Dither(ACESFitted(exposure*color));
			#endif


	//gl_FragData[0].rgb = texture2D(gaux1,texcoord).rgb/10.;
//	gl_FragData[0].rgb = texelFetch2D(noisetex,ivec2(gl_FragCoord.xy),0).rgb;

}
