#version 120

#define EXPOSURE_MULTIPLIER 1.0 //[0.25 0.4 0.5 0.6 0.7 0.75 0.8 0.85 0.9 0.95 1.0 1.1 1.2 1.3 1.4 1.5 2.0 3.0 4.0]

uniform sampler2D gaux1;

varying vec2 texcoord;
varying vec4 fogColor;
varying vec3 exposure;
varying vec3 wsunVec;

uniform int isEyeInWater;

uniform float moonIntensity;
uniform float skyIntensity;
uniform float skyIntensityNight;
uniform float rainStrength;
uniform float sunIntensity;
uniform float fogAmount;

uniform vec2 texelSize;
uniform ivec2 eyeBrightness;
uniform ivec2 eyeBrightnessSmooth;
uniform vec3 sunVec;
uniform vec3 nsunColor;
uniform vec4 lightCol;
uniform mat4 gbufferModelViewInverse;
float luma(vec3 col){
	return dot(col,vec3(0.333));
}
vec3 toLinear(vec3 sRGB){
	return sRGB * (sRGB * (sRGB * 0.305306011 + 0.682171111) + 0.012522878);
}
#include "lib/sky_gradient.glsl"
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	wsunVec = mat3(gbufferModelViewInverse)*sunVec;
	fogColor.rgb = getSkyColorLut(wsunVec*0.85+vec3(0.0,0.15,0.0),wsunVec,0.15+wsunVec.y*0.85,gaux1)*(eyeBrightness.y/255.+0.006)*10.;
	fogColor.a = fogAmount*0.3;

	gl_Position = ftransform();
	texcoord = gl_MultiTexCoord0.xy;
	exposure = EXPOSURE_MULTIPLIER*0.07*vec3(0.61);

	if (isEyeInWater == 1){
		fogColor.rgb = vec3(0.06,0.27,0.35)/luma(vec3(0.06,0.27,0.35))*luma(toLinear(gl_Fog.color.rgb))*11.3;
		fogColor.a = 0.01;
	}

}
