#version 120
const float shadowDistance = 90.0;		//[30 40 50 60 70 80 90 100 110 120 130 140 150]
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/
//#define SEPARATE_AO
#define WAVY_PLANTS
varying vec4 lmtexcoord;
varying vec4 color;
varying vec4 shadowPos;

attribute vec4 mc_Entity;
uniform sampler2D lightmap;
uniform float sunElevation;
uniform vec3 sunVec;
uniform vec3 upVec;
uniform vec4 lightCol;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform float screenBrightness;
attribute vec4 mc_midTexCoord;
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec4 toClipSpace3(vec3 viewSpacePosition) {
    return vec4(projMAD(gl_ProjectionMatrix, viewSpacePosition),-viewSpacePosition.z);
}
#define SHADOW_MAP_BIAS 0.7
float calcDistort(vec2 worlpos){
	vec2 pos = worlpos * 1.165;
	vec2 posSQ = pos*pos;

	float distb = pow(posSQ.x*posSQ.x*posSQ.x + posSQ.y*posSQ.y*posSQ.y, 1.0 / 6.0);
	return (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
}
float luma(vec3 col){
	return dot(col,vec3(0.299,0.587,0.114));
}
vec3 toLinear(vec3 sRGB){
	return sRGB * (sRGB * (sRGB * 0.305306011 + 0.682171111) + 0.012522878);
}
const float PI48 = 150.796447372;
float pi2wt = PI48*frameTimeCounter;
vec2 calcWave(in vec3 pos) {

    float magnitude = abs(sin(dot(vec4(frameTimeCounter, pos),vec4(1.0,0.005,0.005,0.005)))*0.5+0.72)*0.013;
	vec2 ret = (sin(pi2wt*vec2(0.0063,0.0015)*4. - pos.xz + pos.y*0.05)+0.1)*magnitude;

    return ret;
}

vec3 calcMovePlants(in vec3 pos) {
    vec2 move1 = calcWave(pos );
	float move1y = -length(move1);
   return vec3(move1.x,move1y,move1.y)*6./255.;
}

vec3 calcWaveLeaves(in vec3 pos, in float fm, in float mm, in float ma, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5) {

    float magnitude = abs(sin(dot(vec4(frameTimeCounter, pos),vec4(1.0,0.005,0.005,0.005)))*0.5+0.72)*0.013;
	vec3 ret = (sin(pi2wt*vec3(0.0063,0.0224,0.0015)*1.5 - pos))*magnitude;

    return ret;
}

vec3 calcMoveLeaves(in vec3 pos, in float f0, in float f1, in float f2, in float f3, in float f4, in float f5, in vec3 amp1, in vec3 amp2) {
    vec3 move1 = calcWaveLeaves(pos      , 0.0054, 0.0400, 0.0400, 0.0127, 0.0089, 0.0114, 0.0063, 0.0224, 0.0015) * amp1;
    return move1*6./255.;
}
void main() {
	vec3 normal = gl_NormalMatrix * gl_Normal;
	vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;
	lmtexcoord.xy = gl_MultiTexCoord0.xy;


  lmtexcoord.zw = gl_MultiTexCoord1.xy*vec2(15.0/255.0)+0.5;


	float diffuseSun = clamp(dot(normal,sunVec)*lightCol.a,0.0,1.0);


	shadowPos.x = 1e30;
  #ifdef WAVY_PLANTS

  	bool istopv = gl_MultiTexCoord0.t < mc_midTexCoord.t;
    if ((mc_Entity.x == 10001&&istopv)) {
    vec3 worldpos = mat3(gbufferModelViewInverse) * position + gbufferModelViewInverse[3].xyz + cameraPosition;
    worldpos.xyz += calcMovePlants(worldpos.xyz)*gl_MultiTexCoord1.y - cameraPosition;
    position = mat3(gbufferModelView) * worldpos + gbufferModelView[3].xyz ;
    }

    if ((mc_Entity.x == 10003)) {
    vec3 worldpos = mat3(gbufferModelViewInverse) * position + gbufferModelViewInverse[3].xyz + cameraPosition;
    worldpos.xyz += calcMoveLeaves(worldpos.xyz, 0.0040, 0.0064, 0.0043, 0.0035, 0.0037, 0.0041, vec3(1.0,0.2,1.0), vec3(0.5,0.1,0.5))*gl_MultiTexCoord1.y - cameraPosition;
    position = mat3(gbufferModelView) * worldpos + gbufferModelView[3].xyz ;
    }
  #endif
	gl_Position = toClipSpace3(position);
	//skip shadow position calculations if far away
	//normal based rejection is useless in vertex shader
	if (gl_Position.z < shadowDistance+16.0){
		position = mat3(gbufferModelViewInverse) * position + gbufferModelViewInverse[3].xyz;
		shadowPos.xyz = mat3(shadowModelView) * position.xyz + shadowModelView[3].xyz;
		shadowPos.xyz = diagonal3(shadowProjection) * shadowPos.xyz + shadowProjection[3].xyz;
		shadowPos.w = calcDistort(shadowPos.xy);
		shadowPos.xy /= shadowPos.w;
	}

    color = gl_Color;


  if (mc_Entity.x == 10004 || mc_Entity.x == 10003 || mc_Entity.x == 10001){
    shadowPos.w = -shadowPos.w;
    diffuseSun = diffuseSun*0.5+0.6;
  }

  color.a = diffuseSun*gl_MultiTexCoord1.y*luma(toLinear(texture2D(lightmap,vec2(0.5,15.)/16.0).rgb)*230/255.+7/255.);


}
