#version 120
const float shadowDistance = 90.0;		//[30 40 50 60 70 80 90 100 110 120 130 140 150]
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/
//#define SEPARATE_AO
varying vec4 lmtexcoord;
varying vec4 color;
varying vec4 shadowPos;
varying float directL;

attribute vec4 mc_Entity;
uniform sampler2D lightmap;
uniform float sunElevation;
uniform vec3 sunVec;
uniform vec3 upVec;
uniform vec4 lightCol;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;
uniform float screenBrightness;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec4 toClipSpace3(vec3 viewSpacePosition) {
    return vec4(projMAD(gl_ProjectionMatrix, viewSpacePosition),-viewSpacePosition.z);
}
#define SHADOW_MAP_BIAS 0.7
float calcDistort(vec2 worlpos){
	vec2 pos = worlpos * 1.165;
	vec2 posSQ = pos*pos;

	float distb = pow(posSQ.x*posSQ.x*posSQ.x + posSQ.y*posSQ.y*posSQ.y, 1.0 / 6.0);
	return (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
}
float luma(vec3 col){
	return dot(col,vec3(0.299,0.587,0.114));
}
vec3 toLinear(vec3 sRGB){
	return sRGB * (sRGB * (sRGB * 0.305306011 + 0.682171111) + 0.012522878);
}
void main() {
	vec3 normal = gl_NormalMatrix * gl_Normal;
	vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;
	lmtexcoord.xy = gl_MultiTexCoord0.xy;


  lmtexcoord.zw = gl_MultiTexCoord1.xy*vec2(15.0/255.0)+0.5;

	gl_Position = toClipSpace3(position);
	float diffuseSun = clamp(dot(normal,sunVec)*lightCol.a,0.0,1.0)+0.5+0.6;


	shadowPos.x = 1e30;
	//skip shadow position calculations if far away
	//normal based rejection is useless in vertex shader
	if (gl_Position.z < shadowDistance+16.0){
		position = mat3(gbufferModelViewInverse) * position + gbufferModelViewInverse[3].xyz;
		shadowPos.xyz = mat3(shadowModelView) * position.xyz + shadowModelView[3].xyz;
		shadowPos.xyz = diagonal3(shadowProjection) * shadowPos.xyz + shadowProjection[3].xyz;
		shadowPos.w = calcDistort(shadowPos.xy);
		shadowPos.xy /= shadowPos.w;
	}

    color = gl_Color;


  directL = diffuseSun*gl_MultiTexCoord1.y*luma(toLinear(texture2D(lightmap,vec2(0.5,15.)/16.0).rgb)*230/255.+7/255.);


}
