#version 120 //mojang uses v110 by default
/* 
Sildur's fabulous shaders v1.0
https://sildurs-shaders.github.io/
https://twitter.com/Sildurs_shaders
You may not modify and share my work without permission
*/
//---------------------------------------------------------------
//---------------------------------------------------------------
//---------------------------------------------------------------
// Adjust settings and use F3+T ingame to reload the resourcepack

#define Bloom                       //Based of vibrant shaders, WIP
    #define bloom_threshold 1.35    //pixels brighter than this are affected by bloom.
    //#define land_bloom            //WIP has some issues, adjusts bloom for everything that is not sky, improves emissive lighting.

//#define Blobs                     //Modified and ported from MC shaders (secret settings)
    #define blobSize 2.0            //Adjust blob size

//#define Bumpy                     //Modified and ported from MC shaders (secret settings)

//#define Celshading                //Based of vibrant shaders, Black outlines on the edges, comic look like borderlands

//#define Depth_of_Field            //Based of enhanced default, WIP, currently doesnt apply to transparency

#define FXAA                        //Antialiasing, heavily modified fast FXAA v3.11 based of Optifine which uses the original FXAA source by Timothy Lottes (Console PC version)

#define Tonemap                     //Color adjustements based on vibrant and enhanced default shaders.
    #define gamma 2.2               //Adjust gamma used by tonemap

//#define Debug                     //Used for debugging..
//---------------------------------------------------------------
//---------------------------------------------------------------
//---------------------------------------------------------------


uniform sampler2D DiffuseSampler;
uniform sampler2D DiffuseDepthSampler;
uniform sampler2D TranslucentSampler;
uniform sampler2D TranslucentDepthSampler;
uniform sampler2D ItemEntitySampler;
uniform sampler2D ItemEntityDepthSampler;
uniform sampler2D ParticlesSampler;
uniform sampler2D ParticlesDepthSampler;
uniform sampler2D WeatherSampler;
uniform sampler2D WeatherDepthSampler;
uniform sampler2D CloudsSampler;
uniform sampler2D CloudsDepthSampler;

uniform vec2 OutSize;
varying vec2 texCoord;
varying vec2 bumpcoord;
varying vec4 posPos;
varying vec2 oneTexel;  //aspectRatio
float near = 12.0;
float far = 256.0;

#define NUM_LAYERS 6

vec4 color_layers[NUM_LAYERS];
float depth_layers[NUM_LAYERS];
int active_layers = 0;

void try_insert( vec4 color, float depth ) {
    if ( color.a == 0.0 ) {
        return;
    }

    color_layers[active_layers] = color;
    depth_layers[active_layers] = depth;

    int jj = active_layers++;
    int ii = jj - 1;
    while ( jj > 0 && depth_layers[jj] > depth_layers[ii] ) {
        float depthTemp = depth_layers[ii];
        depth_layers[ii] = depth_layers[jj];
        depth_layers[jj] = depthTemp;

        vec4 colorTemp = color_layers[ii];
        color_layers[ii] = color_layers[jj];
        color_layers[jj] = colorTemp;

        jj = ii--;
    }
}

vec3 blend( vec3 dst, vec4 src ) {
    return ( dst * ( 1.0 - src.a ) ) + src.rgb;
}

#ifdef FXAA
float Luma(vec4 rgba) { return dot(rgba.xyz, vec3(0.299, 0.587, 0.114)); }

vec4 calcFXAA() {
    float edgeSharpness = 8.0;          // Edge sharpness: 8.0 (sharp, default) - 2.0 (soft)
    float edgeThreshold = 0.125;        // Edge threshold: 0.125 (softer, def) - 0.25 (sharper)
    float edgeThresholdMin = 0.04;      // 0.06 (faster, dark alias), 0.05 (def), 0.04 (slower, less dark alias)  
    float subpixelremoval = 0.25;       // 0.0 off, 0.25 default

    vec4 pos = vec4(texCoord - oneTexel, texCoord + oneTexel);  
    vec2 offset = vec2(0.50, 1.0) / OutSize;    // N = 0.50 (default), N = 0.33 (sharper)
   
    float lumaNw = Luma(texture2D(DiffuseSampler, pos.xy));
    float lumaSw = Luma(texture2D(DiffuseSampler, pos.xw));
    float lumaNe = Luma(texture2D(DiffuseSampler, pos.zy)) + 1.0/64.0;
    float lumaSe = Luma(texture2D(DiffuseSampler, pos.zw));

    vec4 rgbyM = texture2D(DiffuseSampler, texCoord.xy);
    
    float lumaM = Luma(rgbyM);
    float lumaMaxNwSw = max(lumaNw, lumaSw);
    float lumaMinNwSw = min(lumaNw, lumaSw);
    float lumaMaxNeSe = max(lumaNe, lumaSe);
    float lumaMinNeSe = min(lumaNe, lumaSe);
    float lumaMax = max(lumaMaxNeSe, lumaMaxNwSw);
    float lumaMin = min(lumaMinNeSe, lumaMinNwSw);
    float lumaMaxScaled = lumaMax * edgeThreshold;
    float lumaMinM = min(lumaMin, lumaM);
    float lumaMaxScaledClamped = max(edgeThresholdMin, lumaMaxScaled);
    float lumaMaxM = max(lumaMax, lumaM);
    float dirSwMinusNe = lumaSw - lumaNe;
    float lumaMaxSubMinM = lumaMaxM - lumaMinM;
    float dirSeMinusNw = lumaSe - lumaNw;
    if(lumaMaxSubMinM < lumaMaxScaledClamped) return rgbyM;

    vec2 dir = vec2(dirSwMinusNe + dirSeMinusNw, dirSwMinusNe - dirSeMinusNw);

    vec2 dir1 = normalize(dir.xy);
    vec4 rgbyN1 = texture2D(DiffuseSampler, texCoord.xy - dir1 * offset.xx);
    vec4 rgbyP1 = texture2D(DiffuseSampler, texCoord.xy + dir1 * offset.xx);
    float dirAbsMinTimesC = min(abs(dir1.x), abs(dir1.y)) * edgeSharpness;
    vec2 dir2 = clamp(dir1.xy / dirAbsMinTimesC, -2.0, 2.0);
    vec4 rgbyN2 = texture2D(DiffuseSampler, texCoord.xy - dir2 * offset.yy);
    vec4 rgbyP2 = texture2D(DiffuseSampler, texCoord.xy + dir2 * offset.yy);
    vec4 rgbyA = rgbyN1 + rgbyP1;
    vec4 rgbyB = ((rgbyN2 + rgbyP2) * subpixelremoval) + (rgbyA * subpixelremoval);
    if(Luma(rgbyB) < lumaMin || Luma(rgbyB) > lumaMax) rgbyB.xyz = rgbyA.xyz * 0.5;

    return rgbyB; 
}
#endif

#ifdef Tonemap
vec3 Uncharted2Tonemap(vec3 x) {
	float A = 0.28;
	float B = 0.29;		
	float C = 0.145;
	float D = 0.2;
	float E = 0.025;
	float F = 0.35;
	return (((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F)*gamma;
}
#endif

#ifdef Bloom
vec3 calcBloom(){
    vec3 scalingValues = vec3(1.25, 1.5, bloom_threshold);
    #ifdef land_bloom
        if(texture2D(DiffuseDepthSampler, texCoord).x < (1.0-1.0/32.0/32.0)) scalingValues = vec3(2.5, 2.25, 0.7);
    	const int nSteps = 50;
	    const int center = 24;
    #else
	    const int nSteps = 25;
	    const int center = 12;		//=nSteps-1 / 2
    #endif
	vec3 blur = vec3(0.0);
	float tw = 0.0;
	for (int i; i < nSteps; i++) {
		vec4 offsets = vec4(oneTexel.x, oneTexel.y, i-center, 0.0);			
		float dist = abs(i-float(center))/center;
		float weight = (exp(-(dist*dist)/ 0.28));
		vec3 bsample = texture2D(DiffuseSampler, texCoord.xy + scalingValues.x*offsets.xy*offsets.zw).rgb*scalingValues.y;	//first blur
			 bsample += texture2D(DiffuseSampler,texCoord.xy + 1.25*offsets.xy*offsets.wz).rgb*2.0;	//Second blur

		blur += bsample*weight;
		tw += weight;
	}
	blur /= tw;

	blur = max(vec3(0.0), blur - scalingValues.z); //pixels brighter then this are affected by bloom

	vec3 overglow = blur*pow(length(blur)*2.0,2.8)*2.0;
	return (overglow+blur*1.15)*0.0005;
} 
#endif  

#ifdef Bumpy
vec3 calcBumpy(){
    vec4 c = texture2D(DiffuseSampler, bumpcoord);
    vec4 u = normalize(texture2D(DiffuseSampler, bumpcoord + vec2(0.0, -oneTexel.y)));
    vec4 d = normalize(texture2D(DiffuseSampler, bumpcoord + vec2(0.0,  oneTexel.y)));
    vec4 l = normalize(texture2D(DiffuseSampler, bumpcoord + vec2(-oneTexel.x, 0.0)));
    vec4 r = normalize(texture2D(DiffuseSampler, bumpcoord + vec2( oneTexel.x, 0.0)));

    vec4 nc = normalize(c);
    float du = dot(nc, u);
    float dd = dot(nc, d);
    float dl = dot(nc, l);
    float dr = dot(nc, r);

    float i = 64.0;

    float f = 1.0;
    f += (du * i) - (dd * i);
    f += (dr * i) - (dl * i);

    return (c * clamp(f, 0.5, 2.0)).rgb;
}
#endif

#ifdef Blobs
vec4 calcBlobs(vec4 color){
    float Radius = blobSize;
    for(float u = 0.0; u <= Radius; u += 1.0) {
        for(float v = 0.0; v <= Radius; v += 1.0) {
            float weight = (((sqrt(u * u + v * v) / (Radius)) > 1.0) ? 0.0 : 1.0);

            vec4 s0 = texture2D(DiffuseSampler, bumpcoord + vec2(-u * oneTexel.x, -v * oneTexel.y));
            vec4 s1 = texture2D(DiffuseSampler, bumpcoord + vec2( u * oneTexel.x,  v * oneTexel.y));
            vec4 s2 = texture2D(DiffuseSampler, bumpcoord + vec2(-u * oneTexel.x,  v * oneTexel.y));
            vec4 s3 = texture2D(DiffuseSampler, bumpcoord + vec2( u * oneTexel.x, -v * oneTexel.y));

            vec4 o0 = max(s0, s1);
            vec4 o1 = max(s2, s3);
            vec4 tempMax = max(o0, o1);
            color = mix(color, max(color, tempMax), weight);
        }
    }
    return color;
}
#endif

#ifdef Depth_of_Field
float focal = 0.024;
float aperture = 0.008;	
float sizemult = 25.0;

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float fast_blur[9] = float[9](-0.5, -0.375, -0.25, -0.125, 0.0, 0.125, 0.25, 0.375, 0.5);

vec3 calcDof(){
	float pw = oneTexel.x;
	float z = ld(texture2D(DiffuseDepthSampler, texCoord).x)*far;
	float focus = ld(texture2D(DiffuseDepthSampler, vec2(0.5)).r)*far;
	float pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*15.0);

    vec3 dof_sample = vec3(0.0);
	for ( int i = 0; i < 9; i++) {
		dof_sample += texture2D(DiffuseSampler, texCoord + fast_blur[i]*pcoc*vec2(1.0, OutSize.x)).rgb;
	}
    return dof_sample / 9.0;
}
#endif

#ifdef Celshading
float edepth(vec2 coord) {
	return texture2D(TranslucentDepthSampler,coord).z;
}

vec3 calcCelshade(vec3 color) {
	//edge detect
	float dtresh = 1.0 / (far-near) / 5000.0;
	vec4 dc = vec4(edepth(texCoord.xy));
	vec3 border = vec3(oneTexel, 0.0);
	vec4 sa = vec4(edepth(texCoord.xy + vec2(-border.x,-border.y)),
		 		   edepth(texCoord.xy + vec2(border.x,-border.y)),
		 		   edepth(texCoord.xy + vec2(-border.x,border.z)),
		 		   edepth(texCoord.xy + vec2(border.z,border.y)));

	//opposite side samples
	vec4 sb = vec4(edepth(texCoord.xy + vec2(border.x,border.y)),
		 		   edepth(texCoord.xy + vec2(-border.x,border.y)),
		 		   edepth(texCoord.xy + vec2(border.x,border.z)),
		 		   edepth(texCoord.xy + vec2(border.z,-border.y)));

	vec4 dd = abs(2.0* dc - sa - sb) - dtresh;
		 dd = step(dd.xyzw, vec4(0.0));

	float e = clamp(dot(dd,vec4(0.25f)),0.0,1.0);
	return color*e;
}
#endif

void main() {
    color_layers[0] = vec4( texture2D( DiffuseSampler, texCoord ).rgb, 1.0 );
    depth_layers[0] = texture2D( DiffuseDepthSampler, texCoord ).r;
    active_layers = 1;

    try_insert( texture2D( TranslucentSampler, texCoord ), texture2D( TranslucentDepthSampler, texCoord ).r );
    try_insert( texture2D( ItemEntitySampler, texCoord ), texture2D( ItemEntityDepthSampler, texCoord ).r );
    try_insert( texture2D( ParticlesSampler, texCoord ), texture2D( ParticlesDepthSampler, texCoord ).r );
    try_insert( texture2D( WeatherSampler, texCoord ), texture2D( WeatherDepthSampler, texCoord ).r );
    try_insert( texture2D( CloudsSampler, texCoord ), texture2D( CloudsDepthSampler, texCoord ).r );
    //---------------------------------------------------------------
    //---------------------------------------------------------------
    //---------------------------------------------------------------

    bool isTransparent = texture2D(TranslucentDepthSampler, texCoord).x < texture2D(DiffuseDepthSampler, texCoord).x;
    bool isCloud = texture2D(CloudsDepthSampler, texCoord).x < texture2D(DiffuseDepthSampler, texCoord).x;
    bool notTranslucent = !(isCloud || isTransparent);

    vec4 albedo = color_layers[0];
    
    #ifdef FXAA        
      albedo.rgb = calcFXAA().rgb;   
    #endif

    //Buffer depth swap
    for ( int ii = 1; ii < active_layers; ++ii ) {
        albedo.rgb = blend(albedo.rgb, color_layers[ii]);
    }
    #ifdef Celshading
        albedo.rgb = calcCelshade(albedo.rgb);
    #endif 
if(notTranslucent){
    #ifdef Bumpy  
        if(texture2D(DiffuseDepthSampler, texCoord ).x < 1.0-1.0/48.0/48.0)albedo.rgb = calcBumpy();
    #endif   
    #ifdef Blobs
        albedo = calcBlobs(albedo);
    #endif    
    #ifdef Depth_of_Field
        albedo.rgb = calcDof();
    #endif
    #ifdef Bloom
        albedo.rgb += calcBloom(); 
    #endif
}
    #ifdef Tonemap
        albedo.rgb = Uncharted2Tonemap(albedo.rgb);
    #endif

    gl_FragColor = vec4(albedo.rgb, 1.0);
    //---------------------------------------------------------------

#ifdef Debug
    float inputdepth = texture2D(DiffuseDepthSampler, texCoord).x;
    float nearplane = 1.0;
    float farplane = 1024.0;
    gl_FragColor = vec4((2.0 * nearplane) / (farplane + nearplane - inputdepth * (farplane - nearplane)));  //convert to linear values
#endif
}
