/*
Copyright (C) 2019 RRe36

All Rights Reserved unless otherwise explicitly stated.


By downloading this you have agreed to the license and terms of use.
These can be found inside the included license-file or here: https://github.com/rre36/glsl_kappa/blob/master/LICENSE

Violating these terms may be penalized with actions according to the Digital Millennium Copyright Act (DMCA), the Information Society Directive and/or similar laws depending on your country.
*/


vec4 textureBilinear(sampler2D tex, vec2 coord, const int res) {
    ivec2 texSize = textureSize(tex, 0)*res;
    vec2 texelSize = rcp(vec2(texSize));
    vec4 p0q0 = texture(tex, coord);
    vec4 p1q0 = texture(tex, coord + vec2(texelSize.x, 0));

    vec4 p0q1 = texture(tex, coord + vec2(0, texelSize.y));
    vec4 p1q1 = texture(tex, coord + vec2(texelSize.x , texelSize.y));

    float a = fract(coord.x * texSize.x);

    vec4 pInterp_q0 = mix(p0q0, p1q0, a);
    vec4 pInterp_q1 = mix(p0q1, p1q1, a);

    float b = fract(coord.y*texSize.y);
    return mix(pInterp_q0, pInterp_q1, b);
}

float cloud_mie_dumb(float cos_theta, float g) {
    float sqG   = sqr(g);
    float a     = (1.0-sqG) / (2.0 + sqG);
    float b     = (1.0 + sqr(cos_theta)) / (1.0 + sqG - 2.0*g*cos_theta);

    return max(1.5 * a*b + g*cos_theta, 0.0)*rcp(pi);
}
float cloud_mie(float x, float g) {
    float mie   = 1.0 + sqr(g) - 2.0*g*x;
        mie     = (1.0 - sqr(g)) / ((4.0*pi) * mie*(mie*0.5+0.5));
    return mie;
}

float cloud_phase(float cos_theta, float g) {
    float a     = cloud_mie_dumb(cos_theta, 0.89*g);
    float b     = cloud_mie(cos_theta, -0.25*g)*cloud_bsfade;

    return mix(a, b, 0.38) + 0.24;
}

float vcloud_tick   = frameTimeCounter;

const float vc_size         = 0.17 / 1024.0;
const float vc_highedge     = vcloud_alt + vcloud_depth;

float vcloud_density(vec3 pos) {
    float lfade     = sstep(pos.y, vcloud_alt, vcloud_alt + vcloud_depth * 0.02);
    float hfade     = 1.0 - sstep(pos.y, vc_highedge - vcloud_depth * 0.02, vc_highedge);
    float lerode    = pow3(1.0 - linStep(pos.y, vcloud_alt, vcloud_alt + vcloud_depth*0.2));
    float herode    = pow3(linStep(pos.y, vcloud_alt + vcloud_depth*0.8, vc_highedge));

    #ifdef vcloud_storyMode
    float sfade     = linStep(pos.y, vcloud_alt + 2.0, vc_highedge);
    #endif

        pos.x      += vcloud_tick;
        pos        *= vc_size;

    float shape     = textureBilinear(depthtex2, pos.xz, vcloud_edge).a;
        shape      -= lerode;
        shape      -= herode;
        shape      *= lfade;
        shape      *= hfade;
        shape      -= 0.007;

    #ifdef vcloud_storyMode
        shape      *= pow3(1.0 - sfade) * 0.999 + 0.001;
    #endif

    return max(shape * 2.15, 0.0);
}

float vc_directOD(in vec3 pos, const int steps) {
    vec3 dir    = cloud_lvec;

    float stepsize = (vcloud_depth / steps);
        //stepsize  *= (1.0-linStep(pos.y, vcloud_alt, vc_highedge))*0.9+0.1;

    vec3 rstep   = dir * stepsize;

        pos     += rstep * 0.5;

    float od = 0.0;
    for(int i = 0; i < steps; ++i, pos += rstep) {
        if(pos.y > vc_highedge || pos.y < vcloud_alt) continue;

        float density = vcloud_density(pos);
        od += density*stepsize;
    } 

    return od;
}
float vc_skyOD(in vec3 pos, const int steps) {
    vec3 dir    = vec3(0.0, 1.0, 0.0);

    float stepsize = (vcloud_depth / steps);
        stepsize  *= (1.0-linStep(pos.y, vcloud_alt, vc_highedge))*0.9+0.1;

    float od = 0.0;
    for(int i = 0; i < steps; ++i, pos += dir * stepsize) {
        if(pos.y > vc_highedge || pos.y < vcloud_alt) break;

        float density   = vcloud_density(pos);
        od += density*stepsize;
    } 

    return od;
}

#ifdef layer2_pass
const float vc2_highedge     = vcloud2_alt + vcloud2_depth;

float vcloud2_density(vec3 pos) {
    float lfade     = sstep(pos.y, vcloud2_alt, vcloud2_alt + vcloud2_depth * 0.02);
    float hfade     = 1.0 - sstep(pos.y, vc2_highedge - vcloud2_depth * 0.02, vc2_highedge);
    float lerode    = pow3(1.0 - linStep(pos.y, vcloud2_alt, vcloud2_alt + vcloud2_depth*0.2));
    float herode    = pow3(linStep(pos.y, vcloud2_alt + vcloud2_depth*0.8, vc2_highedge));

    #ifdef vcloud_storyMode
    float sfade     = linStep(pos.y, vcloud2_alt + 2.0, vc2_highedge);
    #endif

        pos.xz      = vec2(-pos.z, pos.x);

        pos.z      += vcloud_tick * 1.3;
        pos        *= vc_size;

    float shape     = textureBilinear(depthtex2, pos.xz, vcloud_edge).a;
        shape      -= lerode;
        shape      -= herode;
        shape      *= lfade;
        shape      *= hfade;
        shape      -= 0.007;

    #ifdef vcloud_storyMode
        shape      *= pow3(1.0 - sfade) * 0.999 + 0.001;
    #endif

    return max(shape * 2.15, 0.0);
}

float vc2_directOD(in vec3 pos, const int steps) {
    vec3 dir    = cloud_lvec;

    float stepsize = (vcloud2_depth / steps);
        //stepsize  *= (1.0-linStep(pos.y, vcloud2_alt, vc2_highedge))*0.9+0.1;

    vec3 rstep   = dir * stepsize;

        pos     += rstep * 0.5;

    float od = 0.0;
    for(int i = 0; i < steps; ++i, pos += rstep) {
        if(pos.y > vc2_highedge || pos.y < vcloud2_alt) continue;

        float density = vcloud2_density(pos);
        od += density*stepsize;
    } 

    return od;
}
float vc2_skyOD(in vec3 pos, const int steps) {
    vec3 dir    = vec3(0.0, 1.0, 0.0);

    float stepsize = (vcloud2_depth / steps);
        stepsize  *= (1.0-linStep(pos.y, vcloud2_alt, vc2_highedge))*0.9+0.1;

    float od = 0.0;
    for(int i = 0; i < steps; ++i, pos += dir * stepsize) {
        if(pos.y > vc2_highedge || pos.y < vcloud2_alt) break;

        float density   = vcloud2_density(pos);
        od += density*stepsize;
    } 

    return od;
}
#endif