/*
Copyright (C) 2019 RRe36

All Rights Reserved unless otherwise explicitly stated.


By downloading this you have agreed to the license and terms of use.
These can be found inside the included license-file or here: https://github.com/rre36/glsl_kappa/blob/master/LICENSE

Violating these terms may be penalized with actions according to the Digital Millennium Copyright Act (DMCA), the Information Society Directive and/or similar laws depending on your country.
*/

#define sunlight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
#define skylight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
#define moonlight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]
#define blocklight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]

#define blocklight_color_preset 0          //[0 1 2 3] 0-warm 1-warm-ish 2-neutral warm 3-neutral

#if blocklight_color_preset==0
    #define blocklight_color vec3(1.0, 0.28, 0.0)
#elif blocklight_color_preset==1
    #define blocklight_color vec3(1.0, 0.36, 0.08)
#elif blocklight_color_preset==2
    #define blocklight_color vec3(1.0, 0.55, 0.23)
#elif blocklight_color_preset==3
    #define blocklight_color vec3(1.0, 0.78, 0.53)
#endif

uniform vec3 sunvec;

uniform float wetness;

uniform vec4 daytime;

flat out float light_flip;

flat out mat4x3 light_color;

#ifdef skypass
uniform vec3 skyColor;
uniform vec3 fogColor;

flat out mat3x3 sky_color;

#include "/lib/util/srgb.glsl"
#endif

#ifdef cloudpass
flat out vec3 cloud_lightcol;
#endif

void make_colors() {

    vec3 sunlightSunrise;
        sunlightSunrise.r   = 1.00;
        sunlightSunrise.g   = 0.32;
        sunlightSunrise.b   = 0.09;
        sunlightSunrise    *= 0.9;

    vec3 sunlightNoon;
        sunlightNoon.r      = 1.00;
        sunlightNoon.g      = 0.89;
        sunlightNoon.b      = 0.74;
        sunlightNoon       *= 1.1;

    vec3 sunlightSunset;
        sunlightSunset.r    = 1.00;
        sunlightSunset.g    = 0.30;
        sunlightSunset.b    = 0.08;
        sunlightSunset     *= 0.9;

    vec3 sunlightNight;
        sunlightNight.r     = 1.00;
        sunlightNight.g     = 0.22;
        sunlightNight.b     = 0.00;
        sunlightNight      *= 0.1;

    #ifdef fogpass
        sunlightSunrise *= vec3(1.0, 0.33, 0.06) * 1.05;
        sunlightSunset *= vec3(1.0, 0.33, 0.06) * 1.05;
    #endif

    light_color[0]  = sunlightSunrise*daytime.x + sunlightNoon*daytime.y + sunlightSunset*daytime.z + sunlightNight*daytime.w;
    //#ifndef skypass
    light_color[0] *= sunlight_luma * pi;
    //#endif

    vec3 skylightSunrise;
        skylightSunrise.r   = 0.8;
        skylightSunrise.g   = 0.8;
        skylightSunrise.b   = 1.00;
        skylightSunrise    *= 0.5;

    vec3 skylightNoon;
        skylightNoon.r      = 0.59;
        skylightNoon.g      = 0.86;
        skylightNoon.b      = 1.00;
        skylightNoon       *= 0.9;

    vec3 skylightSunset;
        skylightSunset.r    = 0.8;
        skylightSunset.g    = 0.8;
        skylightSunset.b    = 1.00;
        skylightSunset     *= 0.5;

    vec3 skylightNight;
        skylightNight.r     = 0.25;
        skylightNight.g     = 0.56;
        skylightNight.b     = 1.00;
        skylightNight      *= 0.01;

    light_color[1]  = skylightSunrise*daytime.x + skylightNoon*daytime.y + skylightSunset*daytime.z + skylightNight*daytime.w;
    light_color[1] *= skylight_luma*0.5;

    light_color[2]  = blocklight_color*blocklight_luma;

    light_color[3]  = vec3(0.13, 0.31, 1.0)*0.15 * moonlight_luma;

    if (wetness > 0.0) {
        light_color[0]  = mix(light_color[0], vec3(v3avg(light_color[0])) * 0.4, wetness * 0.55);
        light_color[1]  = mix(light_color[1], vec3(v3avg(light_color[1])) * 1.5, wetness * 0.75);
        light_color[3]  = mix(light_color[3], vec3(v3avg(light_color[3])) * 0.4, wetness * 0.55);
    }


    float lf    = dot(sunvec, vec3(0.0, 1.0, 0.0))*0.5+0.5;
        lf      = linStep(lf, 0.48, 0.499)*(1.0-linStep(lf, 0.501, 0.52));

    light_flip  = saturate(1.0-lf);

    #ifdef skypass

        vec3 linear_sky = toLinear(skyColor);
        //vec3 linear_sky = toLinear(skyColor);

        vec3 skySunrise = linear_sky;
            //skySunrise.r = 0.24;
            //skySunrise.g = 0.52;
            //skySunrise.b = 1.00;
            skySunrise  *= 0.9;

        vec3 skyNoon = linear_sky * vec3(0.89, 1.18, 1.08);
            //skyNoon.r   = 0.222;
            //skyNoon.g   = 0.486;
            //skyNoon.b   = 1.00;
            skyNoon    *= 0.9;

        vec3 skySunset = linear_sky;
            //skySunset.r = 0.24;
            //skySunset.g = 0.52;
            //skySunset.b = 1.00;
            skySunset  *= 0.9;

        vec3 skyNight;
            skyNight.r  = 0.08;
            skyNight.g  = 0.5;
            skyNight.b  = 1.00;
            skyNight   *= 0.002;

        sky_color[0]    = skySunrise*daytime.x + skyNoon*daytime.y + skySunset*daytime.z + skyNight*daytime.w;

        vec3 horSunrise;
            horSunrise.r = 1.00;
            horSunrise.g = 0.12;
            horSunrise.b = 0.04;
            horSunrise  *= 2.8;

        vec3 horNoon;
            horNoon.r   = 0.48;
            horNoon.g   = 0.72;
            horNoon.b   = 1.00;
            horNoon    *= 4.0;

        vec3 horSunset;
            horSunset.r = 1.00;
            horSunset.g = 0.10;
            horSunset.b = 0.03;
            horSunset  *= 2.8;

        vec3 horNight;
            horNight.r  = 0.08;
            horNight.g  = 0.5;
            horNight.b  = 1.00;
            horNight   *= 0.02;

        sky_color[1]    = horSunrise*sqr(daytime.x) + horNoon*(1.0 - sqr(1.0 - daytime.y)) + horSunset*sqr(daytime.z) + horNight*(1.0 - sqr(1.0 - daytime.w));

        vec3 sgSunrise;
            sgSunrise.r = 1.00;
            sgSunrise.g = 0.12;
            sgSunrise.b = 0.02;
            sgSunrise  *= 4.0;

        vec3 sgNoon;
            sgNoon.r   = 1.0;
            sgNoon.g   = 0.98;
            sgNoon.b   = 0.92;
            sgNoon    *= 4.5;

        vec3 sgSunset;
            sgSunset.r = 1.00;
            sgSunset.g = 0.11;
            sgSunset.b = 0.01;
            sgSunset  *= 4.0;

        vec3 sgNight;
            sgNight.r  = 0.08;
            sgNight.g  = 0.5;
            sgNight.b  = 1.00;
            sgNight   *= 0.02;

        sky_color[2]    = sgSunrise*daytime.x + sgNoon*daytime.y + sgSunset*daytime.z + sgNight*daytime.w;


        if (wetness > 0.0) {
            sky_color[1]    = mix(sky_color[1], vec3(v3avg(sky_color[1])) * 0.5, wetness * 0.9);
            sky_color[2]    = mix(sky_color[2], vec3(v3avg(sky_color[2])) * 0.8, wetness * 0.6);
            //light_color[3]  = mix(light_color[3], vec3(v3avg(light_color[3])) * 0.4, wetness * 0.55);
        }

    #endif

    #ifdef cloudpass
        vec3 c_sunlightSunrise;
            c_sunlightSunrise.r   = 1.00;
            c_sunlightSunrise.g   = 0.14;
            c_sunlightSunrise.b   = 0.02;
            c_sunlightSunrise    *= 0.9;

        vec3 c_sunlightNoon;
            c_sunlightNoon.r      = 1.00;
            c_sunlightNoon.g      = 0.89;
            c_sunlightNoon.b      = 0.74;
            c_sunlightNoon       *= 1.1;

        vec3 c_sunlightSunset;
            c_sunlightSunset.r    = 1.00;
            c_sunlightSunset.g    = 0.12;
            c_sunlightSunset.b    = 0.01;
            c_sunlightSunset     *= 0.9;

        vec3 c_sunlightNight;
            c_sunlightNight.r     = 1.00;
            c_sunlightNight.g     = 0.10;
            c_sunlightNight.b     = 0.01;
            c_sunlightNight      *= 0.4;

        vec3 cloud_sunlight  = c_sunlightSunrise*sqr(daytime.x) + c_sunlightNoon*(1.0 - sqr(1.0 - daytime.y)) + c_sunlightSunset*sqr(daytime.z) + c_sunlightNight*(1.0 - sqr(1.0 - daytime.w));
        cloud_sunlight *= sunlight_luma * pi;

        cloud_lightcol = cloud_sunlight;
    #endif
}