/*
Copyright (C) 2019 RRe36

All Rights Reserved unless otherwise explicitly stated.


By downloading this you have agreed to the license and terms of use.
These can be found inside the included license-file or here: https://github.com/rre36/glsl_kappa/blob/master/LICENSE

Violating these terms may be penalized with actions according to the Digital Millennium Copyright Act (DMCA), the Information Society Directive and/or similar laws depending on your country.
*/

#define nskylight_luma 0.01
#define blocklight_luma 1.0 //[0.2 0.4 0.6 0.8 1.0 1.2 1.4 1.6 1.8 2.0]

#define blocklight_color_preset 0          //[0 1 2 3] 0-warm 1-warm-ish 2-neutral warm 3-neutral

#if blocklight_color_preset==0
    #define blocklight_color vec3(1.0, 0.28, 0.0)
#elif blocklight_color_preset==1
    #define blocklight_color vec3(1.0, 0.36, 0.08)
#elif blocklight_color_preset==2
    #define blocklight_color vec3(1.0, 0.55, 0.23)
#elif blocklight_color_preset==3
    #define blocklight_color vec3(1.0, 0.78, 0.53)
#endif

uniform vec3 sunvec;

uniform vec4 daytime;

flat out float light_flip;

flat out mat2x3 light_color;

#ifdef skypass
flat out vec3 sky_color;
#endif

#define nether_tint_int 1.0    //[0.0 0.2 0.4 0.6 0.8 1.0]

void make_colors() {
    light_color[0]  = vec3(1.0, 0.2, 0.1)*nskylight_luma;
    light_color[0]  = mix(vec3(v3avg(light_color[0])), light_color[0], nether_tint_int);

    light_color[1]  = blocklight_color*blocklight_luma*2.0;


    #ifdef skypass
        sky_color    = vec3(1.0, 0.15, 0.1)*0.004;
    #endif
}