#version 120


const int shadowMapResolution = 512; //[512 768 1024 1536 2048 3172 4096 8192]

varying vec4 lmtexcoord;
varying vec4 color;
varying vec2 normalMat;
varying vec4 shadowPos;

uniform sampler2D texture;
uniform sampler2D gaux1;
uniform sampler2DShadow shadow;

uniform vec4 lightCol;
uniform vec2 texelSize;


//faster and actually more precise than pow 2.2
vec3 toLinear(vec3 sRGB){
	return sRGB * (sRGB * (sRGB * 0.305306011 + 0.682171111) + 0.012522878);
}
float interleaved_gradientNoise(){
	return fract(52.9829189*fract(0.06711056*gl_FragCoord.x + 0.00583715*gl_FragCoord.y));
}
//nb : ignores the -1:0 part
float facos(float sx){
    float x = clamp(abs( sx ),0.,1.);
    return sqrt( 1. - x ) * ( -0.16882 * x + 1.56734 );
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
/* DRAWBUFFERS:1 */
void main() {
	gl_FragData[0] = texture2D(texture, lmtexcoord.xy)*color;
	if (gl_FragData[0].a > 0.0 ) {
		vec3 albedo = toLinear(gl_FragData[0].rgb);

		float diffuseSun = normalMat.x/255.;

		vec3 direct = lightCol.rgb;

		if (abs(shadowPos.x) < 1.0-1.5/shadowMapResolution && abs(shadowPos.y) < 1.0-1.5/shadowMapResolution) {
				const float sr = 0.000125*512./shadowMapResolution;
 				float diffthresh = 10.*sr;
				diffthresh = diffthresh-diffthresh*0.25*interleaved_gradientNoise();

				vec3 projectedShadowPosition = shadowPos.xyz * vec3(0.5,0.5,0.5/3.0) + vec3(0.5,0.5,0.5-diffthresh*shadowPos.w*shadowPos.w);
				diffuseSun *= shadow2D(shadow,projectedShadowPosition).x;
		}

		vec3 lightmap = texture2D(gaux1,lmtexcoord.zw*texelSize).xyz;
		vec3 diffuseLight = lightCol.rgb*diffuseSun + lightmap;

		gl_FragData[0].rgb = diffuseLight*albedo;
	}
}
