#version 120
const float shadowDistance = 45.0;		//[30 40 50 60 70 80 90 100 110 120 130 140 150]
/*
!! DO NOT REMOVE !!
This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/
varying vec4 lmtexcoord;
varying vec4 color;
varying vec2 normalMat;
varying vec4 shadowPos;

attribute vec4 mc_Entity;

uniform float sunElevation;
uniform vec3 sunVec;
uniform vec3 upVec;
uniform vec4 lightCol;
uniform mat4 gbufferModelViewInverse;
uniform mat4 shadowModelView;
uniform mat4 shadowProjection;

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define  projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)
vec4 toClipSpace3(vec3 viewSpacePosition) {
    return vec4(projMAD(gl_ProjectionMatrix, viewSpacePosition),-viewSpacePosition.z);
}
#define SHADOW_MAP_BIAS 0.7
float calcDistort(vec2 worlpos){
	vec2 pos = worlpos * 1.165;
	vec2 posSQ = pos*pos;

	float distb = pow(posSQ.x*posSQ.x*posSQ.x + posSQ.y*posSQ.y*posSQ.y, 1.0 / 6.0);
	float b = (1.0 - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
	return b;
}

void main() {
	vec3 normal = normalize(gl_NormalMatrix * gl_Normal);
	vec3 position = mat3(gl_ModelViewMatrix) * vec3(gl_Vertex) + gl_ModelViewMatrix[3].xyz;
	color = gl_Color;
	lmtexcoord.xy = gl_MultiTexCoord0.xy;


	float NdotU = dot(normal,upVec)*(0.17*15.5/255.)+(0.83*15.5/255.);

	lmtexcoord.zw = gl_MultiTexCoord1.xy*vec2(16./255.0,NdotU)+0.5;



	gl_Position = toClipSpace3(position);
	float diffuseSun = clamp(dot(normal,sunVec)*lightCol.a,0.0,1.0)*0.5+0.6;

  shadowPos.x = 1e30;
	//skip shadow position calculations if far away
	//normal based rejection is useless in vertex shader
	if (gl_Position.z < shadowDistance+16.0){
		position = mat3(gbufferModelViewInverse) * position + gbufferModelViewInverse[3].xyz;
		shadowPos.xyz = mat3(shadowModelView) * position.xyz + shadowModelView[3].xyz;
		shadowPos.xyz = diagonal3(shadowProjection) * shadowPos.xyz + shadowProjection[3].xyz;
		shadowPos.w = calcDistort(shadowPos.xy);
		shadowPos.xy /= shadowPos.w;
	}



	normalMat = vec2(diffuseSun*gl_MultiTexCoord1.y,1.0);
}
